/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ListToCsvStringDeserializer
extends JsonDeserializer<String> {
    ListToCsvStringDeserializer() {
    }

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeNode treeNode = p.getCodec().readTree(p);
        if (treeNode.isContainerNode()) {
            return ListToCsvStringDeserializer.containerNodeToCsvString(treeNode);
        }
        return ListToCsvStringDeserializer.verifyIsTextNode(treeNode).asText();
    }

    private static String containerNodeToCsvString(TreeNode treeNode) {
        return IntStream.range(0, treeNode.size()).mapToObj(index -> ListToCsvStringDeserializer.textNodeToString(treeNode, index)).collect(Collectors.joining(","));
    }

    private static String textNodeToString(TreeNode treeNode, int index) {
        TreeNode node = treeNode.get(index);
        return ListToCsvStringDeserializer.verifyIsTextNode(node).asText();
    }

    private static TextNode verifyIsTextNode(TreeNode node) {
        Verify.verify((boolean)(node instanceof TextNode), (String)"expected node to be TextNode but was: %s", (Object)node.getClass().getName());
        return (TextNode)node;
    }
}

