/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.util;

import java.util.List;
import lombok.Generated;
import org.kiwiproject.registry.model.Port;

public final class Ports {
    public static Port findFirstPortPreferSecure(List<Port> ports, Port.PortType type) {
        Port securePort = Ports.findPort(ports, type, Port.Security.SECURE);
        if (securePort.getNumber() > 0) {
            return securePort;
        }
        return Ports.findPort(ports, type, Port.Security.NOT_SECURE);
    }

    public static Port findPort(List<Port> ports, Port.PortType type, Port.Security security) {
        return ports.stream().filter(p -> p.getType() == type).filter(p -> p.getSecure() == security).findFirst().orElseGet(() -> Port.of(0, type, security));
    }

    public static String determineScheme(List<Port> ports, Port.PortType type) {
        Port firstPort = Ports.findFirstPortPreferSecure(ports, type);
        return firstPort.getSecure().getScheme();
    }

    @Generated
    private Ports() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

