/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.client;

import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.KiwiThrowables;
import org.kiwiproject.jaxrs.KiwiGenericTypes;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.client.ServiceInstanceFilter;
import org.kiwiproject.registry.eureka.client.EurekaParser;
import org.kiwiproject.registry.eureka.common.EurekaInstance;
import org.kiwiproject.registry.eureka.common.EurekaRestClient;
import org.kiwiproject.registry.eureka.common.EurekaUrlProvider;
import org.kiwiproject.registry.eureka.config.EurekaConfig;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.retry.KiwiRetryer;
import org.kiwiproject.retry.KiwiRetryerPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRegistryClient
implements RegistryClient {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(EurekaRegistryClient.class);
    private static final int EUREKA_ATTEMPT_MULTIPLIER = 3;
    private static final int RETRY_MULTIPLIER = 100;
    private static final int RETRY_MAX_TIME = 30;
    private static final TimeUnit RETRY_MAX_TIME_UNIT = TimeUnit.SECONDS;
    private final EurekaRestClient client;
    private final EurekaUrlProvider urlProvider;
    private final KiwiRetryer<Response> clientRetryer;

    public EurekaRegistryClient(EurekaConfig config, EurekaRestClient client) {
        this.client = client;
        this.urlProvider = new EurekaUrlProvider(config.getRegistryUrls());
        int maxAttempts = this.urlProvider.urlCount() * 3;
        this.clientRetryer = KiwiRetryer.builder().exceptionPredicates(List.of(KiwiRetryerPredicates.CONNECTION_ERROR, KiwiRetryerPredicates.NO_ROUTE_TO_HOST, KiwiRetryerPredicates.SOCKET_TIMEOUT, KiwiRetryerPredicates.SSL_HANDSHAKE_ERROR, KiwiRetryerPredicates.UNKNOWN_HOST, EurekaRegistryClient.temporaryServerSideStatusCodes())).maxAttempts(maxAttempts).waitStrategy(this.getWaitStrategy()).build();
    }

    private static Predicate<Throwable> temporaryServerSideStatusCodes() {
        return t -> {
            if (t instanceof ServerErrorException) {
                return EurekaRegistryClient.checkIfDesiredStatusCodeValueIsFoundIn((ServerErrorException)t);
            }
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            if (rootCause instanceof ServerErrorException) {
                return EurekaRegistryClient.checkIfDesiredStatusCodeValueIsFoundIn((ServerErrorException)rootCause);
            }
            LOG.warn("Will NOT retry after receiving {} error considered to be not temporary", (Object)KiwiThrowables.typeOfNullable((Throwable)t).orElse("<unknown>"));
            LOG.debug("Error corresponding to above message:", t);
            return false;
        };
    }

    private static boolean checkIfDesiredStatusCodeValueIsFoundIn(ServerErrorException exception) {
        switch (Response.Status.fromStatusCode((int)exception.getResponse().getStatus())) {
            case BAD_GATEWAY: 
            case SERVICE_UNAVAILABLE: 
            case GATEWAY_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    WaitStrategy getWaitStrategy() {
        return WaitStrategies.exponentialWait((long)100L, (long)30L, (TimeUnit)RETRY_MAX_TIME_UNIT);
    }

    @Override
    public Optional<ServiceInstance> findServiceInstanceBy(String serviceName) {
        return this.findServiceInstanceBy(RegistryClient.InstanceQuery.builder().serviceName(serviceName).build());
    }

    @Override
    public Optional<ServiceInstance> findServiceInstanceBy(String serviceName, String instanceId) {
        KiwiPreconditions.checkArgumentNotBlank((String)instanceId, (String)"The instance ID cannot be blank");
        List<ServiceInstance> instances = this.findAllServiceInstancesBy(serviceName);
        return instances.stream().filter(instance -> instance.getInstanceId().equals(instanceId)).findFirst();
    }

    @Override
    public Optional<ServiceInstance> findServiceInstanceBy(RegistryClient.InstanceQuery query) {
        List<ServiceInstance> instances = this.findAllServiceInstancesBy(query);
        if (instances.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(EurekaRegistryClient.selectRandom(instances));
    }

    @Override
    public List<ServiceInstance> findAllServiceInstancesBy(String serviceName) {
        return this.findAllServiceInstancesBy(RegistryClient.InstanceQuery.builder().serviceName(serviceName).build());
    }

    @Override
    public List<ServiceInstance> findAllServiceInstancesBy(RegistryClient.InstanceQuery query) {
        KiwiPreconditions.checkArgumentNotNull((Object)query, (String)"The query cannot be null");
        KiwiPreconditions.checkArgumentNotBlank((String)query.getServiceName(), (String)"The service name cannot be blank");
        List<EurekaInstance> eurekaInstances = this.getRunningServiceInstancesFromEureka(query.getServiceName());
        List<ServiceInstance> serviceInstances = eurekaInstances.stream().map(EurekaInstance::toServiceInstance).collect(Collectors.toList());
        return ServiceInstanceFilter.filterInstancesByVersion(serviceInstances, query);
    }

    private List<EurekaInstance> getRunningServiceInstancesFromEureka(String vipAddress) {
        Response response = this.getRegisteredServicesFromEureka(vipAddress);
        if (Objects.isNull(response)) {
            return List.of();
        }
        return EurekaParser.parseEurekaResponse((Map)response.readEntity(KiwiGenericTypes.MAP_OF_STRING_TO_OBJECT_GENERIC_TYPE)).stream().filter(instance -> ServiceInstance.Status.UP.name().equals(instance.getStatus())).collect(Collectors.toList());
    }

    private Response getRegisteredServicesFromEureka(String vipAddress) {
        return (Response)this.clientRetryer.call(() -> {
            String targetUrl = this.urlProvider.getCurrentEurekaUrl();
            LOG.debug("Attempting to lookup {} using {}", (Object)vipAddress, (Object)targetUrl);
            try {
                return this.client.findInstancesByVipAddress(targetUrl, vipAddress);
            }
            catch (Exception e) {
                this.urlProvider.getNextEurekaUrl();
                throw e;
            }
        });
    }

    private static <T> T selectRandom(List<T> items) {
        int index = EurekaRegistryClient.selectRandomIndex(items);
        return items.get(index);
    }

    private static <T> int selectRandomIndex(List<T> items) {
        return ThreadLocalRandom.current().nextInt(items.size());
    }
}

