/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.common;

import java.beans.ConstructorProperties;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.kiwiproject.registry.eureka.common.EurekaInstance;
import org.kiwiproject.registry.model.ServiceInstance;

public class EurekaRestClient {
    private static final String APP_INSTANCE_PATH_TEMPLATE = "/apps/{appId}/{instanceId}";
    private static final String APP_ID = "appId";
    private static final String INSTANCE_ID = "instanceId";
    private final Client client;

    public EurekaRestClient() {
        this(ClientBuilder.newClient());
    }

    public Response register(String eurekaUrl, String appId, EurekaInstance instanceToRegister) {
        return this.client.target(eurekaUrl).path("/apps/{appId}").resolveTemplate(APP_ID, (Object)appId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)"application/json").post(Entity.json(Map.of("instance", instanceToRegister)));
    }

    public Response findInstance(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public Response findInstancesByVipAddress(String eurekaUrl, String vipAddress) {
        return this.client.target(eurekaUrl).path("/vips/{vipAddress}").resolveTemplate("vipAddress", (Object)vipAddress).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public Response updateStatus(String eurekaUrl, String appId, String instanceId, ServiceInstance.Status newStatus) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).path("status").resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).queryParam("value", new Object[]{newStatus.name()}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)"{}"));
    }

    public Response unregister(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
    }

    public Response sendHeartbeat(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)"{}"));
    }

    @ConstructorProperties(value={"client"})
    @Generated
    public EurekaRestClient(Client client) {
        this.client = client;
    }
}

