/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.consul.client;

import com.orbitz.consul.Consul;
import com.orbitz.consul.model.catalog.CatalogService;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.net.KiwiUrls;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.client.ServiceInstanceFilter;
import org.kiwiproject.registry.consul.config.ConsulConfig;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.model.ServicePaths;

public class ConsulRegistryClient
implements RegistryClient {
    private static final String ADMIN_PORT_FIELD = "adminPort";
    private static final List<String> METADATA_EXCLUDED_KEYS = List.of("commitRef", "description", "version", "homePagePath", "healthCheckPath", "statusPath", "scheme", "adminPort", "ipAddress");
    private static final Set<String> TAGS_EXCLUDED = Set.of("service-type:default");
    private final Consul consul;
    private final ConsulConfig config;

    public ConsulRegistryClient(Consul consul, ConsulConfig config) {
        this.config = (ConsulConfig)KiwiPreconditions.requireNotNull((Object)config);
        this.consul = (Consul)KiwiPreconditions.requireNotNull((Object)consul);
    }

    @Override
    public Optional<ServiceInstance> findServiceInstanceBy(String serviceName, String instanceId) {
        KiwiPreconditions.checkArgumentNotBlank((String)instanceId, (String)"The instance ID cannot be blank");
        List<ServiceInstance> instances = this.findAllServiceInstancesBy(serviceName);
        return instances.stream().filter(instance -> instance.getInstanceId().equals(instanceId)).findFirst();
    }

    @Override
    public List<ServiceInstance> findAllServiceInstancesBy(RegistryClient.InstanceQuery query) {
        KiwiPreconditions.checkArgumentNotNull((Object)query, (String)"The query cannot be null");
        KiwiPreconditions.checkArgumentNotBlank((String)query.getServiceName(), (String)"The service name cannot be blank");
        List services = (List)this.consul.catalogClient().getService(query.getServiceName()).getResponse();
        List<ServiceInstance> convertedServices = services.stream().map(this::fromCatalogService).collect(Collectors.toList());
        return ServiceInstanceFilter.filterInstancesByVersion(convertedServices, query);
    }

    private ServiceInstance fromCatalogService(CatalogService catalogService) {
        Map metadata = catalogService.getServiceMeta();
        String scheme = (String)metadata.get("scheme");
        ArrayList<Port> ports = new ArrayList<Port>();
        Port port = Port.builder().number(catalogService.getServicePort()).secure(Port.Security.fromScheme(scheme)).type(Port.PortType.APPLICATION).build();
        ports.add(port);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)metadata.get(ADMIN_PORT_FIELD)))) {
            Port adminPort = Port.builder().number(Integer.parseInt((String)metadata.get(ADMIN_PORT_FIELD))).secure(Port.Security.fromScheme(scheme)).type(Port.PortType.ADMIN).build();
            ports.add(adminPort);
        }
        Map<String, String> serviceMetadata = this.filterMetadata(metadata);
        this.addTagsToMetadata(serviceMetadata, catalogService.getServiceTags());
        return ServiceInstance.builder().instanceId(catalogService.getServiceId()).serviceName(catalogService.getServiceName()).hostName(this.adjustAddressIfNeeded(catalogService.getServiceAddress(), scheme)).ports(ports).paths(ServicePaths.builder().homePagePath((String)metadata.get("homePagePath")).statusPath((String)metadata.get("statusPath")).healthCheckPath((String)metadata.get("healthCheckPath")).build()).commitRef((String)metadata.get("commitRef")).description((String)metadata.get("description")).version((String)metadata.get("version")).status(ServiceInstance.Status.UP).ip((String)metadata.get("ipAddress")).metadata(serviceMetadata).build();
    }

    private Map<String, String> filterMetadata(Map<String, String> metadata) {
        return metadata.entrySet().stream().filter(entry -> !METADATA_EXCLUDED_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void addTagsToMetadata(Map<String, String> metadata, List<String> tags) {
        List<String> filteredTags = tags.stream().filter(tag -> !TAGS_EXCLUDED.contains(tag)).collect(Collectors.toList());
        if (KiwiLists.isNotNullOrEmpty(filteredTags)) {
            filteredTags.forEach(tag -> {
                if (tag.contains(":")) {
                    String[] tagSplit = tag.split(":");
                    metadata.put(tagSplit[0], tagSplit[1]);
                } else {
                    metadata.put((String)tag, (String)tag);
                }
            });
        }
    }

    private String adjustAddressIfNeeded(String hostname, String scheme) {
        if (StringUtils.isBlank((CharSequence)this.config.getDomainOverride())) {
            return hostname;
        }
        try {
            URL url = new URL(KiwiUrls.replaceDomainsIn((String)(scheme + "://" + hostname), (String)this.config.getDomainOverride()));
            return url.getHost();
        }
        catch (Exception e) {
            return hostname;
        }
    }
}

