/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.registry.eureka.common.EurekaInstance;

final class EurekaParser {
    public static List<EurekaInstance> parseEurekaResponse(Map<String, Object> response) {
        KiwiPreconditions.checkArgumentNotNull(response, (String)"Eureka response map cannot be null");
        Map applications = (Map)response.get("applications");
        Preconditions.checkState((boolean)Objects.nonNull(applications), (Object)"Eureka data must contain a key 'applications' that contains a Map<String, Object>");
        Object applicationOrApplicationList = applications.get("application");
        ArrayList<EurekaInstance> eurekaInstances = new ArrayList<EurekaInstance>();
        if (Objects.nonNull(applicationOrApplicationList)) {
            if (applicationOrApplicationList instanceof List) {
                for (Map application : (List)applicationOrApplicationList) {
                    Object instances = application.get("instance");
                    eurekaInstances.addAll(EurekaParser.parseInstances(instances));
                }
            } else {
                eurekaInstances.addAll(EurekaParser.parseInstances(((Map)applicationOrApplicationList).get("instance")));
            }
        }
        return eurekaInstances;
    }

    private static List<EurekaInstance> parseInstances(Object instanceOrInstanceList) {
        KiwiPreconditions.checkArgumentNotNull((Object)instanceOrInstanceList, (String)"Instance data from Eureka can not be null");
        if (instanceOrInstanceList instanceof List) {
            List instanceList = (List)instanceOrInstanceList;
            return instanceList.stream().map(EurekaParser::buildInstance).collect(Collectors.toList());
        }
        Map instance = (Map)instanceOrInstanceList;
        return Lists.newArrayList((Object[])new EurekaInstance[]{EurekaParser.buildInstance(instance)});
    }

    private static EurekaInstance buildInstance(Map<String, Object> instanceData) {
        Map portMap = (Map)instanceData.get("port");
        Map securePortMap = (Map)instanceData.get("securePort");
        Map metadataMap = (Map)instanceData.get("metadata");
        Map leaseInfoMap = (Map)instanceData.get("leaseInfo");
        Map<String, Object> leaseInfo = Objects.nonNull(leaseInfoMap) ? Map.of("renewalIntervalInSecs", leaseInfoMap.getOrDefault("renewalIntervalInSecs", 0), "durationInSecs", leaseInfoMap.getOrDefault("durationInSecs", 0), "registrationTimestamp", leaseInfoMap.getOrDefault("registrationTimestamp", 0L), "lastRenewalTimestamp", leaseInfoMap.getOrDefault("lastRenewalTimestamp", 0L), "evictionTimestamp", leaseInfoMap.getOrDefault("evictionTimestamp", 0L), "serviceUpTimestamp", leaseInfoMap.getOrDefault("serviceUpTimestamp", 0L)) : Map.of();
        return EurekaInstance.builder().vipAddress(EurekaParser.getString(instanceData, "vipAddress")).secureVipAddress(EurekaParser.getString(instanceData, "vipAddress")).app(EurekaParser.getString(instanceData, "app")).hostName(EurekaParser.getString(instanceData, "hostName")).ipAddr(EurekaParser.getString(instanceData, "ipAddr")).status(EurekaParser.getString(instanceData, "status")).homePageUrl(EurekaParser.getString(instanceData, "homePageUrl")).healthCheckUrl(EurekaParser.getString(instanceData, "healthCheckUrl")).statusPageUrl(EurekaParser.getString(instanceData, "statusUrl")).port(portMap).securePort(securePortMap).leaseInfo(leaseInfo).metadata(metadataMap).build();
    }

    private static <K> String getString(Map<? super K, ?> map, K key) {
        Object value = map.getOrDefault(key, null);
        Verify.verify((Objects.isNull(value) || value instanceof String ? 1 : 0) != 0, (String)"Value from Map must be a string or null", (Object[])new Object[0]);
        return value;
    }

    @Generated
    private EurekaParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

