/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.Optionals;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.eureka.common.EurekaInstance;
import org.kiwiproject.registry.eureka.common.EurekaRestClient;
import org.kiwiproject.registry.eureka.common.EurekaUrlProvider;
import org.kiwiproject.registry.eureka.config.EurekaRegistrationConfig;
import org.kiwiproject.registry.eureka.server.EurekaHeartbeatSender;
import org.kiwiproject.registry.exception.RegistrationException;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.server.RegistryService;
import org.kiwiproject.retry.SimpleRetryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRegistryService
implements RegistryService {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(EurekaRegistryService.class);
    @VisibleForTesting
    static final DateTimeFormatter APP_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSS").withZone(ZoneOffset.UTC);
    private static final String DEFAULT_DATA_CENTER_INFO_CLASS = "com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo";
    private static final String DEFAULT_DATA_CENTER_NAME = "MyOwn";
    private static final String LEASE_DURATION_IN_SECONDS = "durationInSecs";
    private static final String LEASE_RENEWAL_INTERVAL_IN_SECONDS = "renewalIntervalInSecs";
    public static final int MAX_AWAIT_REGISTRATION_CONFIRMATION_TRIES = 10;
    public static final int MAX_REGISTRATION_ATTEMPTS = 60;
    private static final long RETRY_DELAY = 1L;
    private static final TimeUnit RETRY_DELAY_UNIT = TimeUnit.SECONDS;
    private static final long UNREGISTER_RETRY_DELAY = 3L;
    private static final TimeUnit UNREGISTER_RETRY_DELAY_UNIT = TimeUnit.SECONDS;
    private static final int MAX_UNREGISTER_ATTEMPTS = 5;
    private static final int MAX_UPDATE_STATUS_ATTEMPTS = 5;
    private final EurekaRegistrationConfig config;
    private final EurekaRestClient client;
    private final SimpleRetryer registerRetryer;
    private final SimpleRetryer awaitRetryer;
    private final SimpleRetryer updateStatusRetryer;
    private final SimpleRetryer unregisterRetryer;
    private final KiwiEnvironment environment;
    private final EurekaUrlProvider urlProvider;
    @VisibleForTesting
    final AtomicReference<EurekaInstance> registeredInstance;
    @VisibleForTesting
    final AtomicReference<ScheduledExecutorService> heartbeatExecutor;

    public EurekaRegistryService(EurekaRegistrationConfig config, EurekaRestClient client, KiwiEnvironment environment) {
        this.config = config;
        this.client = client;
        this.environment = environment;
        this.urlProvider = new EurekaUrlProvider(config.getRegistryUrls());
        this.registeredInstance = new AtomicReference();
        this.heartbeatExecutor = new AtomicReference();
        this.registerRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(60).retryDelayTime(1L).retryDelayUnit(RETRY_DELAY_UNIT).build();
        this.awaitRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(10).retryDelayTime(1L).retryDelayUnit(RETRY_DELAY_UNIT).build();
        this.updateStatusRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(5).retryDelayTime(1L).retryDelayUnit(RETRY_DELAY_UNIT).build();
        this.unregisterRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(5).retryDelayTime(3L).retryDelayUnit(UNREGISTER_RETRY_DELAY_UNIT).build();
    }

    @Override
    public ServiceInstance createCandidateFrom(ServiceInfo serviceInfo) {
        return ServiceInstance.fromServiceInfo(serviceInfo).withStatus(ServiceInstance.Status.STARTING);
    }

    @Override
    public ServiceInstance register(ServiceInstance serviceToRegister) {
        Preconditions.checkState((boolean)this.isNotRegistered(), (String)"Cannot register. Already managing a registered instance: %s", (Object)this.registeredInstance.get());
        String appId = KiwiStrings.f((String)"{}-{}", (Object[])new Object[]{serviceToRegister.getServiceName(), APP_TIMESTAMP_FORMATTER.format(this.environment.currentInstant())}).toUpperCase(Locale.getDefault());
        this.registerWithEureka(appId, serviceToRegister);
        EurekaInstance registeredInstanceFromEureka = this.waitForInstanceToBeRegistered(appId, serviceToRegister.getHostName());
        if (Objects.isNull(registeredInstanceFromEureka)) {
            return null;
        }
        this.registeredInstance.set(registeredInstanceFromEureka);
        LOG.info("Successful registration of app {}, instance {} with vip address {}", new Object[]{registeredInstanceFromEureka.getApp(), registeredInstanceFromEureka.getInstanceId(), registeredInstanceFromEureka.getVipAddress()});
        this.startHeartbeat();
        return registeredInstanceFromEureka.toServiceInstance();
    }

    private void startHeartbeat() {
        if (Objects.nonNull(this.heartbeatExecutor.get())) {
            this.shutdownHeartbeat();
        }
        int heartbeatInterval = this.config.getHeartbeatIntervalInSeconds();
        LOG.debug("Starting heartbeat with interval {} seconds", (Object)heartbeatInterval);
        this.heartbeatExecutor.set(EurekaRegistryService.newHeartbeatExecutor());
        this.heartbeatExecutor.get().scheduleWithFixedDelay(new EurekaHeartbeatSender(this.client, this, this.registeredInstance.get(), this.urlProvider), heartbeatInterval, heartbeatInterval, TimeUnit.SECONDS);
    }

    private void shutdownHeartbeat() {
        ScheduledExecutorService executor = this.heartbeatExecutor.get();
        if (Objects.isNull(executor)) {
            LOG.trace("Heartbeat executor was null; nothing to shut down.");
            return;
        }
        LOG.info("Shutting heartbeat executor down: {}", (Object)executor);
        List<Runnable> tasks = executor.shutdownNow();
        if (KiwiLists.isNotNullOrEmpty(tasks)) {
            LOG.info("There are {} task(s) that never started for heartbeat executor: {}", (Object)tasks.size(), (Object)executor);
        }
        try {
            boolean terminated = executor.awaitTermination(5L, TimeUnit.SECONDS);
            LOG.info("Heartbeat executor {} terminated before timeout? {}", (Object)executor, (Object)terminated);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted waiting for termination of heartbeat executor {}", (Object)executor);
        }
        this.heartbeatExecutor.set(null);
    }

    private static ScheduledExecutorService newHeartbeatExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("eureka-heartbeat-%d").setDaemon(true).build();
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private void registerWithEureka(String appId, ServiceInstance serviceToRegister) {
        EurekaInstance eurekaInstance = EurekaInstance.fromServiceInstance(serviceToRegister).withApp(appId).withStatus(serviceToRegister.getStatus().name()).withDataCenterInfo(Map.of("name", DEFAULT_DATA_CENTER_NAME, "@class", DEFAULT_DATA_CENTER_INFO_CLASS)).withLeaseInfo(Map.of(LEASE_DURATION_IN_SECONDS, this.config.getExpirationIntervalInSeconds(), LEASE_RENEWAL_INTERVAL_IN_SECONDS, this.config.getHeartbeatIntervalInSeconds()));
        Function<String, Response> registrationFunction = this.registrationSender(appId, eurekaInstance);
        Response response = (Response)this.registerRetryer.tryGetObject(this.eurekaCallRetrySupplier(registrationFunction, Response.Status.NO_CONTENT.getStatusCode())).orElseThrow(() -> {
            String errMsg = KiwiStrings.format((String)"Received errors or non-204 responses on ALL %s attempts to register (via POST) with Eureka", (Object[])new Object[]{60});
            return new RegistrationException(errMsg);
        });
        LOG.info("Registration for app {} has been received by Eureka", (Object)appId);
        LOG.debug("Response from server: Status [{}], Body {}", (Object)response.getStatus(), response.readEntity(String.class));
    }

    private Function<String, Response> registrationSender(String appId, EurekaInstance candidate) {
        return eurekaUrl -> {
            try {
                return this.client.register((String)eurekaUrl, appId, candidate);
            }
            catch (Exception e) {
                LOG.error("Failed to register app {} with body {} to Eureka at {}", new Object[]{appId, candidate, eurekaUrl, e});
                return null;
            }
        };
    }

    private EurekaInstance waitForInstanceToBeRegistered(String appId, String instanceId) {
        LOG.debug("Wait for registration to show in Eureka for app {}, instance {}", (Object)appId, (Object)instanceId);
        Function<String, Response> instanceGetterFunction = this.instanceRequester(appId, instanceId);
        Optional response = this.awaitRetryer.tryGetObject(this.eurekaCallRetrySupplier(instanceGetterFunction, Response.Status.OK.getStatusCode()));
        return response.map(resp -> (EurekaInstance)((Map)resp.readEntity((GenericType)new GenericType<Map<String, EurekaInstance>>(){})).get("instance")).orElseThrow(() -> {
            LOG.error("Registration failed, or there is some other problem getting app {}, instance {}", (Object)appId, (Object)instanceId);
            String errMsg = KiwiStrings.format((String)"Unable to obtain app %s, instance %s from Eureka during registration after %s attempts", (Object[])new Object[]{appId, instanceId, 10});
            return new RegistrationException(errMsg);
        });
    }

    private Function<String, Response> instanceRequester(String appId, String instanceId) {
        return eurekaUrl -> {
            try {
                return this.client.findInstance((String)eurekaUrl, appId, instanceId);
            }
            catch (Exception e) {
                LOG.error("Failed to get instance with appId {}, instanceId {} from Eureka at {} due to unexpected exception", new Object[]{appId, instanceId, eurekaUrl, e});
                return null;
            }
        };
    }

    @Override
    public ServiceInstance updateStatus(ServiceInstance.Status newStatus) {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Can not update status before calling register");
        EurekaInstance instanceToUnregister = this.registeredInstance.get();
        String appId = instanceToUnregister.getApp();
        String instanceId = instanceToUnregister.getInstanceId();
        Optional response = this.updateStatusRetryer.tryGetObject(this.eurekaCallRetrySupplier(this.updateStatusSender(appId, instanceId, newStatus), Response.Status.OK.getStatusCode()));
        Optionals.ifPresentOrElseThrow((Optional)response, resp -> {
            LOG.info("Instance with appId {}, instanceId {} has been updated successfully to status {}", new Object[]{appId, instanceId, newStatus});
            this.registeredInstance.set(instanceToUnregister.withStatus(newStatus.name()));
        }, () -> {
            String msg = KiwiStrings.format((String)"Error updating status for app {}, instance {}", (Object[])new Object[]{appId, instanceId});
            LOG.error(msg);
            return new RegistrationException(msg);
        });
        return this.registeredInstance.get().toServiceInstance();
    }

    private Function<String, Response> updateStatusSender(String appId, String instanceId, ServiceInstance.Status newStatus) {
        return eurekaUrl -> {
            try {
                return this.client.updateStatus((String)eurekaUrl, appId, instanceId, newStatus);
            }
            catch (Exception e) {
                LOG.error("Failed to update status to {} for instance with appId {}, instanceId {} from Eureka at {} due to unexpected exception", new Object[]{newStatus, appId, instanceId, eurekaUrl, e});
                return null;
            }
        };
    }

    @Override
    public void unregister() {
        this.shutdownHeartbeat();
        if (this.isNotRegistered()) {
            LOG.warn("Ignoring un-register request because not currently registered (call register first)");
            return;
        }
        this.unregisterFromEureka();
    }

    private void unregisterFromEureka() {
        EurekaInstance instanceToUnregister = this.registeredInstance.get();
        String appId = instanceToUnregister.getApp();
        String instanceId = instanceToUnregister.getInstanceId();
        Optional response = this.unregisterRetryer.tryGetObject(this.eurekaCallRetrySupplier(this.unregisterSender(appId, instanceId), Response.Status.OK.getStatusCode()));
        Optionals.ifPresentOrElseThrow((Optional)response, resp -> {
            LOG.info("Instance with appId {}, instanceId {} has been unregistered successfully", (Object)appId, (Object)instanceId);
            this.registeredInstance.set(null);
        }, () -> {
            String msg = KiwiStrings.format((String)"Error un-registering app {}, instance {}", (Object[])new Object[]{appId, instanceId});
            LOG.error(msg);
            return new RegistrationException(msg);
        });
    }

    private Function<String, Response> unregisterSender(String appId, String instanceId) {
        return eurekaUrl -> {
            try {
                return this.client.unregister((String)eurekaUrl, appId, instanceId);
            }
            catch (Exception e) {
                LOG.error("Failed to unregister instance with appId {}, instanceId {} from Eureka at {} due to unexpected exception", new Object[]{appId, instanceId, eurekaUrl, e});
                return null;
            }
        };
    }

    private boolean isRegistered() {
        return Objects.nonNull(this.registeredInstance.get());
    }

    private boolean isNotRegistered() {
        return !this.isRegistered();
    }

    private Supplier<Response> eurekaCallRetrySupplier(Function<String, Response> restCallFunction, int successfulStatusCode) {
        return () -> {
            String eurekaUrl = this.urlProvider.getCurrentEurekaUrl();
            LOG.debug("Attempting a call to Eureka");
            Response response = (Response)restCallFunction.apply(eurekaUrl);
            if (Objects.isNull(response)) {
                this.urlProvider.getNextEurekaUrl();
                LOG.error("Call to Eureka failed. See previous error for details");
                return null;
            }
            if (successfulStatusCode == response.getStatus()) {
                return response;
            }
            this.urlProvider.getNextEurekaUrl();
            LOG.error("HTTP {} - Call to Eureka at {} failed to respond successfully. Response body: {}", new Object[]{response.getStatus(), eurekaUrl, response.readEntity(String.class)});
            return null;
        };
    }

    void clearRegisteredInstance() {
        this.registeredInstance.set(null);
    }

    @Generated
    AtomicReference<EurekaInstance> getRegisteredInstance() {
        return this.registeredInstance;
    }
}

