/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.common;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.net.KiwiUrls;

public class EurekaUrlProvider {
    private final Iterator<String> eurekaUrlCycler;
    private final Lock cyclerLock;
    private final AtomicReference<String> currentEurekaUrl;
    private final List<String> eurekaUrls;

    public EurekaUrlProvider(String commaSeparatedUrls) {
        this.eurekaUrls = KiwiUrls.stripTrailingSlashes((List)KiwiStrings.splitOnCommas((CharSequence)commaSeparatedUrls));
        this.eurekaUrlCycler = Iterators.cycle(this.eurekaUrls);
        this.cyclerLock = new ReentrantLock();
        this.currentEurekaUrl = new AtomicReference();
    }

    public int urlCount() {
        return this.eurekaUrls.size();
    }

    public String getCurrentEurekaUrl() {
        if (Objects.isNull(this.currentEurekaUrl.get())) {
            return this.getNextEurekaUrl();
        }
        return this.currentEurekaUrl.get();
    }

    public String getNextEurekaUrl() {
        try {
            this.cyclerLock.lock();
            String next = this.eurekaUrlCycler.next();
            this.currentEurekaUrl.set(next);
            String string = next;
            return string;
        }
        finally {
            this.cyclerLock.unlock();
        }
    }
}

