/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.consul.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiEnvironment;
import org.kiwiproject.base.KiwiStrings;
import org.kiwiproject.base.Optionals;
import org.kiwiproject.base.UUIDs;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.collect.KiwiMaps;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.model.agent.ImmutableRegCheck;
import org.kiwiproject.consul.model.agent.ImmutableRegistration;
import org.kiwiproject.consul.model.agent.Registration;
import org.kiwiproject.net.KiwiUrls;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.consul.config.ConsulRegistrationConfig;
import org.kiwiproject.registry.consul.server.ConsulHelpers;
import org.kiwiproject.registry.exception.RegistrationException;
import org.kiwiproject.registry.model.Port;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.server.RegistryService;
import org.kiwiproject.registry.util.Ports;
import org.kiwiproject.registry.util.ServiceInstancePaths;
import org.kiwiproject.retry.SimpleRetryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegistryService
implements RegistryService {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ConsulRegistryService.class);
    @VisibleForTesting
    static final int MAX_REGISTRATION_ATTEMPTS = 60;
    private static final long RETRY_DELAY = 1L;
    private static final TimeUnit RETRY_DELAY_UNIT = TimeUnit.SECONDS;
    private static final long UNREGISTER_RETRY_DELAY = 3L;
    private static final TimeUnit UNREGISTER_RETRY_DELAY_UNIT = TimeUnit.SECONDS;
    private static final int MAX_UNREGISTER_ATTEMPTS = 5;
    private final Consul consul;
    private final ConsulRegistrationConfig config;
    private final SimpleRetryer registerRetryer;
    private final SimpleRetryer unregisterRetryer;
    private final List<String> metadataTags;
    private final AtomicReference<ServiceInstance> registeredService;

    public ConsulRegistryService(Consul consul, ConsulRegistrationConfig config, KiwiEnvironment environment) {
        this.consul = consul;
        this.config = config;
        this.registeredService = new AtomicReference();
        this.metadataTags = config.getMetadataTags();
        this.registerRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(60).retryDelayTime(1L).retryDelayUnit(RETRY_DELAY_UNIT).build();
        this.unregisterRetryer = SimpleRetryer.builder().environment(environment).maxAttempts(5).retryDelayTime(3L).retryDelayUnit(UNREGISTER_RETRY_DELAY_UNIT).build();
    }

    @Override
    public ServiceInstance createCandidateFrom(ServiceInfo serviceInfo) {
        return ServiceInstance.fromServiceInfo(serviceInfo).withStatus(ServiceInstance.Status.UP);
    }

    @Override
    public ServiceInstance register(ServiceInstance serviceToRegister) {
        Preconditions.checkState((!this.isRegistered() ? 1 : 0) != 0, (Object)"Cannot register. Already managing a registered instance");
        Registration registration = this.fromServiceInstance(serviceToRegister);
        Optional serviceOptional = this.registerRetryer.tryGetObject("registered ServiceInstance", () -> {
            this.consul.agentClient().register(registration);
            return serviceToRegister.withInstanceId(registration.getId()).withHostName(registration.getAddress().orElse(null));
        });
        if (serviceOptional.isEmpty()) {
            LOG.error("Registration failed for service {} with id {}. See logs above", (Object)serviceToRegister.getServiceName(), (Object)registration.getId());
            String errMsg = KiwiStrings.format((String)"Unable to register service %s, id %s with Consul after %s attempts", (Object[])new Object[]{serviceToRegister.getServiceName(), registration.getId(), 60});
            throw new RegistrationException(errMsg);
        }
        this.setRegisteredServiceInstance((ServiceInstance)serviceOptional.get());
        return this.copyOfRegisteredServiceInstance();
    }

    @Override
    public ServiceInstance updateStatus(ServiceInstance.Status newStatus) {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Can not update status before calling register");
        LOG.warn("Ignoring status update as Consul handles its own status through its health check process");
        return this.copyOfRegisteredServiceInstance();
    }

    private ServiceInstance copyOfRegisteredServiceInstance() {
        return this.getRegisteredServiceInstance().toBuilder().build();
    }

    @Override
    public void unregister() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot unregister since registration was never called");
        String serviceName = this.getRegisteredServiceInstance().getServiceName();
        String instanceId = this.getRegisteredServiceInstance().getInstanceId();
        LOG.info("Unregistering service {} with id {}", (Object)serviceName, (Object)instanceId);
        Optional result = this.unregisterRetryer.tryGetObject("unregister result", () -> {
            this.consul.agentClient().deregister(this.getRegisteredServiceInstance().getInstanceId());
            return instanceId;
        });
        Optionals.ifPresentOrElseThrow((Optional)result, id -> {
            LOG.info("Service with name {} and id {} has been unregistered successfully", (Object)serviceName, (Object)instanceId);
            this.setRegisteredServiceInstance(null);
        }, () -> {
            String msg = KiwiStrings.format((String)"Error un-registering service {}, id {}", (Object[])new Object[]{serviceName, instanceId});
            LOG.error(msg);
            return new RegistrationException(msg);
        });
    }

    private boolean isRegistered() {
        return Objects.nonNull(this.getRegisteredServiceInstance());
    }

    @VisibleForTesting
    void setRegisteredServiceInstance(ServiceInstance serviceInstance) {
        this.registeredService.set(serviceInstance);
    }

    private Registration fromServiceInstance(ServiceInstance serviceInstance) {
        ImmutableRegCheck check = ImmutableRegCheck.builder().http(ServiceInstancePaths.urlForPath(serviceInstance.getHostName(), serviceInstance.getPorts(), Port.PortType.ADMIN, serviceInstance.getPaths().getStatusPath())).interval(KiwiStrings.format((String)"{}s", (Object[])new Object[]{this.config.getCheckIntervalInSeconds()})).deregisterCriticalServiceAfter(KiwiStrings.format((String)"{}m", (Object[])new Object[]{this.config.getDeregisterIntervalInMinutes()})).build();
        String address = this.adjustAddressIfNeeded(serviceInstance);
        return ImmutableRegistration.builder().port(Ports.findFirstPortPreferSecure(serviceInstance.getPorts(), Port.PortType.APPLICATION).getNumber()).check((Registration.RegCheck)check).id(UUIDs.randomUUIDString()).name(serviceInstance.getServiceName()).address(address).tags(this.buildTags(serviceInstance)).meta(ConsulRegistryService.mergeMetadata(serviceInstance)).build();
    }

    private List<String> buildTags(ServiceInstance serviceInstance) {
        ArrayList<String> tags = new ArrayList<String>(List.of("service-type:default"));
        if (KiwiMaps.isNullOrEmpty(serviceInstance.getMetadata()) || KiwiLists.isNullOrEmpty(this.metadataTags)) {
            return tags;
        }
        List metadataAsTags = serviceInstance.getMetadata().entrySet().stream().filter(entry -> this.metadataTags.contains(entry.getKey())).map(entry -> KiwiStrings.f((String)"{}:{}", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.toList());
        tags.addAll(metadataAsTags);
        return tags;
    }

    private static Map<String, String> mergeMetadata(ServiceInstance serviceInstance) {
        Map<String, String> defaultMetadataMap = ConsulHelpers.newDefaultMetadata(serviceInstance);
        if (KiwiMaps.isNullOrEmpty(serviceInstance.getMetadata())) {
            return defaultMetadataMap;
        }
        return Stream.concat(defaultMetadataMap.entrySet().stream(), serviceInstance.getMetadata().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value2));
    }

    private String adjustAddressIfNeeded(ServiceInstance instance) {
        if (StringUtils.isBlank((CharSequence)this.config.getDomainOverride())) {
            return instance.getHostName();
        }
        String urlString = ServiceInstancePaths.urlForPath(instance.getHostName(), instance.getPorts(), Port.PortType.APPLICATION, instance.getPaths().getHomePagePath());
        try {
            URL url = new URL(KiwiUrls.replaceDomainsIn((String)urlString, (String)this.config.getDomainOverride()));
            return url.getHost();
        }
        catch (MalformedURLException e) {
            return instance.getHostName();
        }
    }

    @VisibleForTesting
    ServiceInstance getRegisteredServiceInstance() {
        return this.registeredService.get();
    }
}

