/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.base.KiwiThrowables;
import org.kiwiproject.jaxrs.KiwiResponses;
import org.kiwiproject.logging.LazyLogParameterSupplier;
import org.kiwiproject.registry.eureka.common.EurekaInstance;
import org.kiwiproject.registry.eureka.common.EurekaRestClient;
import org.kiwiproject.registry.eureka.common.EurekaUrlProvider;
import org.kiwiproject.registry.eureka.server.EurekaRegistryService;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.retry.KiwiRetryerPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EurekaHeartbeatSender
implements Runnable {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(EurekaHeartbeatSender.class);
    public static final int HEARTBEAT_FAILURE_THRESHOLD = 5;
    private final EurekaRestClient client;
    private final EurekaInstance registeredInstance;
    private final EurekaRegistryService registryService;
    private final EurekaUrlProvider urlProvider;
    @VisibleForTesting
    private int heartbeatFailures;
    @VisibleForTesting
    private Instant heartbeatFailureStartedAt;
    private final Runnable heartbeatSentListener;

    EurekaHeartbeatSender(EurekaRestClient client, EurekaRegistryService registryService, EurekaInstance registeredInstance, EurekaUrlProvider urlProvider, Runnable heartbeatSentListener) {
        this.client = client;
        this.registeredInstance = registeredInstance;
        this.registryService = registryService;
        this.urlProvider = urlProvider;
        this.heartbeatSentListener = heartbeatSentListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Response response = null;
        Exception exception = null;
        try {
            LOG.trace("Sending heartbeat at {} for appId {} and instanceId {} ({})", new Object[]{LazyLogParameterSupplier.lazy(() -> DateTimeFormatter.ISO_INSTANT.format(Instant.now())), this.registeredInstance.getApp(), this.registeredInstance.getInstanceId(), this});
            response = this.client.sendHeartbeat(this.urlProvider.getCurrentEurekaUrl(), this.registeredInstance.getApp(), this.registeredInstance.getInstanceId());
            KiwiResponses.closeQuietly((Response)response);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            KiwiResponses.closeQuietly(response);
        }
        if (Objects.nonNull(response) && KiwiResponses.successful(response)) {
            this.logRecoveryIfNecessary();
            this.heartbeatFailures = 0;
            this.heartbeatFailureStartedAt = null;
            this.heartbeatSentListener.run();
            return;
        }
        ++this.heartbeatFailures;
        this.urlProvider.getNextEurekaUrl();
        if (this.heartbeatFailures == 1) {
            LOG.trace("Recording initial heartbeat failure date/time");
            this.heartbeatFailureStartedAt = Instant.now();
        } else if (this.heartbeatFailuresExistWithoutInitialStartTime()) {
            LOG.warn("We're in an invalid state somehow; {} heartbeatFailures but null heartbeatFailureStartedAt. Setting it to be safe...", (Object)this.heartbeatFailures);
            this.heartbeatFailureStartedAt = Instant.now();
        }
        this.logHeartbeatFailure(response, exception);
        if (this.heartbeatFailures > 5) {
            LOG.error("Exceeded heartbeat failure threshold of {}. Start self-healing.", (Object)5);
            this.handleHeartbeatFailuresExceededMax(response, exception);
        }
    }

    private void logRecoveryIfNecessary() {
        if (this.heartbeatFailures > 0) {
            String duration = this.durationSinceFirstHeartbeatFailure();
            LOG.info("And after {} straight heartbeat failure(s) and {} away, we're back!", (Object)this.heartbeatFailures, (Object)duration);
        }
    }

    private boolean heartbeatFailuresExistWithoutInitialStartTime() {
        return this.heartbeatFailures > 1 && Objects.isNull(this.heartbeatFailureStartedAt);
    }

    private void logHeartbeatFailure(@Nullable Response response, @Nullable Exception heartbeatException) {
        String exceptionTypeOrNo;
        String duration = this.durationSinceFirstHeartbeatFailure();
        String statusOrNoResponse = Objects.isNull(response) ? "<no response>" : String.valueOf(response.getStatus());
        String string = exceptionTypeOrNo = Objects.isNull(heartbeatException) ? "<no exception>" : heartbeatException.getClass().getCanonicalName();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Heartbeat to Eureka failed. ({} failure(s) in a row, elapsed time {}, response status: {}, exception: {})", new Object[]{this.heartbeatFailures, duration, statusOrNoResponse, exceptionTypeOrNo, heartbeatException});
        } else {
            EurekaHeartbeatSender.logHeartbeatFailureWithMoreExceptionInfo(this.heartbeatFailures, duration, statusOrNoResponse, exceptionTypeOrNo, heartbeatException);
        }
    }

    @VisibleForTesting
    static void logHeartbeatFailureWithMoreExceptionInfo(int heartbeatFailures, String duration, String statusOrNoResponse, String exceptionTypeOrNo, @Nullable Exception heartbeatException) {
        String message = KiwiThrowables.messageOfNullable((Throwable)heartbeatException).orElse(null);
        Throwable rootCause = KiwiThrowables.rootCauseOfNullable((Throwable)heartbeatException).orElse(null);
        Throwable cause = rootCause == heartbeatException ? null : rootCause;
        String causeType = KiwiThrowables.typeOfNullable((Throwable)cause).orElse(null);
        String causeMessage = KiwiThrowables.messageOfNullable((Throwable)cause).orElse(null);
        LOG.warn("Heartbeat to Eureka failed ({} failure(s) in a row, elapsed time {}, response status: {}, [exception: {}, message: {}], [root cause: {}, message: {}])", new Object[]{heartbeatFailures, duration, statusOrNoResponse, exceptionTypeOrNo, message, causeType, causeMessage});
    }

    private String durationSinceFirstHeartbeatFailure() {
        Preconditions.checkNotNull((Object)this.heartbeatFailureStartedAt, (Object)"heartbeatFailureStartedAt should not be null here, but it was");
        Duration duration = Duration.between(this.heartbeatFailureStartedAt, Instant.now());
        return DurationFormatUtils.formatDurationWords((long)duration.toMillis(), (boolean)true, (boolean)true);
    }

    @VisibleForTesting
    FailureHandlerResult handleHeartbeatFailuresExceededMax(Response response, Exception exception) {
        LOG.warn("Heartbeat failure threshold exceeded, so marking as no longer registered");
        this.registryService.clearRegisteredInstance();
        if (EurekaHeartbeatSender.isCannotConnect(exception)) {
            LOG.error("Received ConnectException, indicating a network partition. Cannot self-heal right now.");
            return FailureHandlerResult.CANNOT_SELF_HEAL;
        }
        if (EurekaHeartbeatSender.isSocketTimeout(exception)) {
            LOG.error("Received SocketTimeoutException, indicating a (possibly temporary) network problem. Cannot self-heal right now.");
            return FailureHandlerResult.CANNOT_SELF_HEAL;
        }
        if (EurekaHeartbeatSender.receivedNotFound(response)) {
            LOG.error("Eureka reporting 404 Not Found for heartbeat. Eureka probably expired our registration. Will attempt to re-register...");
            try {
                ServiceInstance serviceToRegister = this.registeredInstance.toServiceInstance().withStatus(ServiceInstance.Status.UP);
                ServiceInstance registeredService = this.registryService.register(serviceToRegister);
                LOG.info("Self-healing complete. Re-registered {} on {} with Eureka as app {}", new Object[]{registeredService.getServiceName(), registeredService.getHostName(), this.registryService.getRegisteredAppOrNull()});
                return FailureHandlerResult.SELF_HEALING_SUCCEEDED;
            }
            catch (Exception e) {
                LOG.error("Error re-registering app {}. Self-healing failed.", (Object)this.registeredInstance.getApp(), (Object)e);
                return FailureHandlerResult.SELF_HEALING_FAILED;
            }
        }
        LOG.error("Able to connect to Eureka, but receiving unknown error. Cannot self-heal right now.", (Throwable)exception);
        return FailureHandlerResult.CANNOT_SELF_HEAL;
    }

    private static boolean isCannotConnect(@Nullable Exception exception) {
        return KiwiRetryerPredicates.CONNECTION_ERROR.test(exception);
    }

    private static boolean isSocketTimeout(@Nullable Exception exception) {
        return KiwiRetryerPredicates.SOCKET_TIMEOUT.test(exception);
    }

    private static boolean receivedNotFound(@Nullable Response response) {
        return Objects.nonNull(response) && response.getStatus() == 404;
    }

    @Generated
    int getHeartbeatFailures() {
        return this.heartbeatFailures;
    }

    @Generated
    void setHeartbeatFailures(int heartbeatFailures) {
        this.heartbeatFailures = heartbeatFailures;
    }

    @Generated
    Instant getHeartbeatFailureStartedAt() {
        return this.heartbeatFailureStartedAt;
    }

    @Generated
    void setHeartbeatFailureStartedAt(Instant heartbeatFailureStartedAt) {
        this.heartbeatFailureStartedAt = heartbeatFailureStartedAt;
    }

    static enum FailureHandlerResult {
        CANNOT_SELF_HEAL,
        SELF_HEALING_FAILED,
        SELF_HEALING_SUCCEEDED;

    }
}

