/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.kiwiproject.registry.config.ServiceInfo;
import org.kiwiproject.registry.model.ServiceInstance;
import org.kiwiproject.registry.server.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopRegistryService
implements RegistryService {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(NoopRegistryService.class);
    @VisibleForTesting
    private ServiceInstance dummyInstance;

    @Override
    public ServiceInstance createCandidateFrom(ServiceInfo serviceInfo) {
        LOG.info("Create dummy service [{}] candidate with service name: {}", (Object)serviceInfo.humanReadableName(), (Object)serviceInfo.getName());
        return ServiceInstance.builder().instanceId(UUID.randomUUID().toString()).serviceName(serviceInfo.getName()).hostName(serviceInfo.getHostname()).ip(serviceInfo.getIp()).status(ServiceInstance.Status.STARTING).commitRef(serviceInfo.getCommitRef()).description(serviceInfo.getDescription()).ports(serviceInfo.getPorts()).version(serviceInfo.getVersion()).paths(serviceInfo.getPaths()).build();
    }

    @Override
    public ServiceInstance register(ServiceInstance serviceToRegister) {
        if (Objects.isNull(this.dummyInstance)) {
            this.dummyInstance = serviceToRegister.toBuilder().status(ServiceInstance.Status.UP).build();
        }
        return this.dummyInstance;
    }

    @Override
    public ServiceInstance updateStatus(ServiceInstance.Status newStatus) {
        Preconditions.checkState((boolean)Objects.nonNull(this.dummyInstance), (Object)"Can not update status before calling register");
        this.dummyInstance = this.dummyInstance.withStatus(newStatus);
        return this.dummyInstance;
    }

    @Override
    public void unregister() {
        LOG.info("Un-registering dummy service: service [{}], instance [{}]", (Object)this.dummyInstance.getServiceName(), (Object)this.dummyInstance.getInstanceId());
        this.dummyInstance = null;
    }

    @Generated
    ServiceInstance getDummyInstance() {
        return this.dummyInstance;
    }

    @Generated
    void setDummyInstance(ServiceInstance dummyInstance) {
        this.dummyInstance = dummyInstance;
    }
}

