/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.model.ServiceInstance;

public class MultiRegistryClient
implements RegistryClient {
    @VisibleForTesting
    private final List<RegistryClient> registryClients;

    public MultiRegistryClient(List<RegistryClient> registryClients) {
        KiwiPreconditions.checkArgumentNotEmpty(registryClients, (String)"registryClients must not be null or empty");
        this.registryClients = List.copyOf(registryClients);
    }

    public static MultiRegistryClient of(RegistryClient ... registryClients) {
        KiwiPreconditions.checkArgumentNotNull((Object)registryClients, (String)"registryClients varargs must not be null");
        Preconditions.checkArgument((registryClients.length > 0 ? 1 : 0) != 0, (Object)"at least one RegistryClient must be provided");
        return new MultiRegistryClient(List.of(registryClients));
    }

    @Override
    public Optional<ServiceInstance> findServiceInstanceBy(String serviceName, String instanceId) {
        return this.registryClients.stream().map(registryClient -> registryClient.findServiceInstanceBy(serviceName, instanceId)).flatMap(Optional::stream).findFirst();
    }

    @Override
    public List<ServiceInstance> findAllServiceInstancesBy(RegistryClient.InstanceQuery query) {
        return this.registryClients.stream().map(registryClient -> registryClient.findAllServiceInstancesBy(query)).filter(KiwiLists::isNotNullOrEmpty).flatMap(Collection::stream).toList();
    }

    @Override
    public List<ServiceInstance> retrieveAllRegisteredInstances() {
        return this.registryClients.stream().map(RegistryClient::retrieveAllRegisteredInstances).filter(KiwiLists::isNotNullOrEmpty).flatMap(Collection::stream).toList();
    }

    @Generated
    List<RegistryClient> getRegistryClients() {
        return this.registryClients;
    }
}

