/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.client;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.registry.model.ServiceInstance;

public interface RegistryClient {
    default public Optional<ServiceInstance> findServiceInstanceBy(String serviceName) {
        return this.findServiceInstanceBy(InstanceQuery.builder().serviceName(serviceName).build());
    }

    public Optional<ServiceInstance> findServiceInstanceBy(String var1, String var2);

    default public Optional<ServiceInstance> findServiceInstanceBy(InstanceQuery query) {
        List<ServiceInstance> instances = this.findAllServiceInstancesBy(query);
        if (instances.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RegistryClient.selectRandom(instances));
    }

    default public List<ServiceInstance> findAllServiceInstancesBy(String serviceName) {
        return this.findAllServiceInstancesBy(InstanceQuery.builder().serviceName(serviceName).build());
    }

    public List<ServiceInstance> findAllServiceInstancesBy(InstanceQuery var1);

    private static <T> T selectRandom(List<T> items) {
        int index = RegistryClient.selectRandomIndex(items);
        return items.get(index);
    }

    private static <T> int selectRandomIndex(List<T> items) {
        return ThreadLocalRandom.current().nextInt(items.size());
    }

    public List<ServiceInstance> retrieveAllRegisteredInstances();

    public static class InstanceQuery {
        private final String serviceName;
        private final String minimumVersion;
        private final String preferredVersion;

        public boolean hasNoVersionPredicates() {
            return this.hasNoMinimumVersion() && this.hasNoPreferredVersion();
        }

        public boolean hasNoMinimumVersion() {
            return StringUtils.isBlank((CharSequence)this.minimumVersion);
        }

        public boolean hasNoPreferredVersion() {
            return StringUtils.isBlank((CharSequence)this.preferredVersion);
        }

        @ConstructorProperties(value={"serviceName", "minimumVersion", "preferredVersion"})
        @Generated
        InstanceQuery(String serviceName, String minimumVersion, String preferredVersion) {
            this.serviceName = serviceName;
            this.minimumVersion = minimumVersion;
            this.preferredVersion = preferredVersion;
        }

        @Generated
        public static InstanceQueryBuilder builder() {
            return new InstanceQueryBuilder();
        }

        @Generated
        public String getServiceName() {
            return this.serviceName;
        }

        @Generated
        public String getMinimumVersion() {
            return this.minimumVersion;
        }

        @Generated
        public String getPreferredVersion() {
            return this.preferredVersion;
        }

        @Generated
        public static class InstanceQueryBuilder {
            @Generated
            private String serviceName;
            @Generated
            private String minimumVersion;
            @Generated
            private String preferredVersion;

            @Generated
            InstanceQueryBuilder() {
            }

            @Generated
            public InstanceQueryBuilder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Generated
            public InstanceQueryBuilder minimumVersion(String minimumVersion) {
                this.minimumVersion = minimumVersion;
                return this;
            }

            @Generated
            public InstanceQueryBuilder preferredVersion(String preferredVersion) {
                this.preferredVersion = preferredVersion;
                return this;
            }

            @Generated
            public InstanceQuery build() {
                return new InstanceQuery(this.serviceName, this.minimumVersion, this.preferredVersion);
            }

            @Generated
            public String toString() {
                return "RegistryClient.InstanceQuery.InstanceQueryBuilder(serviceName=" + this.serviceName + ", minimumVersion=" + this.minimumVersion + ", preferredVersion=" + this.preferredVersion + ")";
            }
        }
    }
}

