/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.common;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.glassfish.jersey.message.GZipEncoder;
import org.kiwiproject.registry.eureka.common.EurekaInstance;
import org.kiwiproject.registry.model.ServiceInstance;

public class EurekaRestClient {
    private static final String APP_INSTANCE_PATH_TEMPLATE = "/apps/{appId}/{instanceId}";
    private static final String APP_ID = "appId";
    private static final String INSTANCE_ID = "instanceId";
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 5000;
    private final Client client;

    public EurekaRestClient() {
        this(EurekaRestClient.newClient());
    }

    private static Client newClient() {
        return (Client)((Client)((Client)ClientBuilder.newClient().register(GZipEncoder.class)).property("jersey.config.client.connectTimeout", (Object)1000)).property("jersey.config.client.readTimeout", (Object)5000);
    }

    public Response register(String eurekaUrl, String appId, EurekaInstance instanceToRegister) {
        return this.client.target(eurekaUrl).path("/apps/{appId}").resolveTemplate(APP_ID, (Object)appId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Content-Type", (Object)"application/json").post(Entity.json(Map.of("instance", instanceToRegister)));
    }

    public Response findInstance(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public Response findAllInstances(String eurekaUrl) {
        return this.client.target(eurekaUrl).path("/apps").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public Response findInstancesByVipAddress(String eurekaUrl, String vipAddress) {
        return this.client.target(eurekaUrl).path("/vips/{vipAddress}").resolveTemplate("vipAddress", (Object)vipAddress).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
    }

    public Response updateStatus(String eurekaUrl, String appId, String instanceId, ServiceInstance.Status newStatus) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).path("status").resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).queryParam("value", new Object[]{newStatus.name()}).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)"{}"));
    }

    public Response unregister(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
    }

    public Response sendHeartbeat(String eurekaUrl, String appId, String instanceId) {
        return this.client.target(eurekaUrl).path(APP_INSTANCE_PATH_TEMPLATE).resolveTemplate(APP_ID, (Object)appId).resolveTemplate(INSTANCE_ID, (Object)instanceId).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)"{}"));
    }

    @ConstructorProperties(value={"client"})
    @Generated
    public EurekaRestClient(Client client) {
        this.client = client;
    }
}

