/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.client;

import java.util.List;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.base.Versions;
import org.kiwiproject.registry.client.RegistryClient;
import org.kiwiproject.registry.model.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceInstanceFilter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInstanceFilter.class);

    public static List<ServiceInstance> filterInstancesByVersion(List<ServiceInstance> serviceInstances, RegistryClient.InstanceQuery query) {
        if (serviceInstances.isEmpty()) {
            LOG.trace("No running instances were found for service name {}", (Object)query.getServiceName());
            return List.of();
        }
        if (query.hasNoVersionPredicates()) {
            return List.copyOf(serviceInstances);
        }
        List<ServiceInstance> instancesSatisfyingMinVersion = serviceInstances.stream().filter(instance -> query.hasNoMinimumVersion() || ServiceInstanceFilter.versionIsAtLeast(instance, query.getMinimumVersion())).toList();
        if (instancesSatisfyingMinVersion.isEmpty()) {
            LOG.trace("No running instances for service name {} satisfy the minimum version {}", (Object)query.getServiceName(), (Object)query.getMinimumVersion());
            return List.of();
        }
        List<ServiceInstance> instancesSatisfyingPreferredVersion = instancesSatisfyingMinVersion.stream().filter(instance -> query.hasNoPreferredVersion() || ServiceInstanceFilter.versionIsExactly(instance, query.getPreferredVersion())).toList();
        if (instancesSatisfyingPreferredVersion.isEmpty()) {
            LOG.trace("No running instances for service name {} match preferred version {}; finding latest instead", (Object)query.getServiceName(), (Object)query.getPreferredVersion());
            return List.copyOf(ServiceInstanceFilter.findInstancesWithLatestVersion(serviceInstances));
        }
        return List.copyOf(instancesSatisfyingPreferredVersion);
    }

    public static boolean versionIsAtLeast(ServiceInstance instance, String version) {
        ServiceInstanceFilter.validateVersions(instance, version);
        return Versions.isHigherOrSameVersion((String)instance.getVersion(), (String)version);
    }

    public static boolean versionIsExactly(ServiceInstance instance, String version) {
        ServiceInstanceFilter.validateVersions(instance, version);
        return Versions.isSameVersion((String)instance.getVersion(), (String)version);
    }

    private static void validateVersions(ServiceInstance instance, String version) {
        KiwiPreconditions.checkArgumentNotBlank((String)version, (String)"version to compare cannot be blank");
        KiwiPreconditions.checkArgumentNotNull((Object)instance.getVersion(), (String)"instance version cannot be null");
    }

    public static List<ServiceInstance> findInstancesWithLatestVersion(List<ServiceInstance> serviceInstances) {
        String maxVersion = serviceInstances.stream().map(ServiceInstance::getVersion).max(Versions::versionCompare).orElseThrow(IllegalStateException::new);
        return serviceInstances.stream().filter(instance -> ServiceInstanceFilter.versionIsExactly(instance, maxVersion)).toList();
    }

    @Generated
    private ServiceInstanceFilter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

