/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.util;

import com.google.common.base.Preconditions;
import java.util.List;
import lombok.Generated;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.collect.KiwiLists;
import org.kiwiproject.registry.model.Port;

public final class Ports {
    public static Port findOnlyApplicationPort(List<Port> ports) {
        List<Port> applicationPorts = Ports.findApplicationPorts(ports);
        Ports.checkExactlyOnePort(applicationPorts, "application");
        return (Port)KiwiLists.first(applicationPorts);
    }

    public static List<Port> findApplicationPorts(List<Port> ports) {
        return Ports.findPorts(ports, Port.PortType.APPLICATION);
    }

    public static Port findOnlyAdminPort(List<Port> ports) {
        List<Port> adminPorts = Ports.findAdminPorts(ports);
        Ports.checkExactlyOnePort(adminPorts, "admin");
        return (Port)KiwiLists.first(adminPorts);
    }

    private static void checkExactlyOnePort(List<Port> ports, String portType) {
        int numPorts = ports.size();
        Preconditions.checkState((numPorts == 1 ? 1 : 0) != 0, (String)"expected one %s port but found %s", (Object)portType, (int)numPorts);
    }

    public static List<Port> findAdminPorts(List<Port> ports) {
        return Ports.findPorts(ports, Port.PortType.ADMIN);
    }

    public static List<Port> findPorts(List<Port> ports, Port.PortType portType) {
        KiwiPreconditions.checkArgumentNotNull((Object)((Object)portType), (String)"portType must not be null");
        return ports.stream().filter(port -> port.getType() == portType).toList();
    }

    public static Port findFirstPortPreferSecure(List<Port> ports, Port.PortType type) {
        Port securePort = Ports.findPort(ports, type, Port.Security.SECURE);
        if (securePort.getNumber() > 0) {
            return securePort;
        }
        return Ports.findPort(ports, type, Port.Security.NOT_SECURE);
    }

    public static Port findPort(List<Port> ports, Port.PortType type, Port.Security security) {
        return ports.stream().filter(p -> p.getType() == type).filter(p -> p.getSecure() == security).findFirst().orElseGet(() -> Port.of(0, type, security));
    }

    public static String determineScheme(List<Port> ports, Port.PortType type) {
        Port firstPort = Ports.findFirstPortPreferSecure(ports, type);
        return firstPort.getSecure().getScheme();
    }

    @Generated
    private Ports() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

