/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.base.KiwiObjects;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.net.KiwiInternetAddresses;
import org.kiwiproject.registry.eureka.common.EurekaInstance;

public final class EurekaResponseParser {
    private static final String INSTANCE_KEY = "instance";

    public static List<EurekaInstance> parseEurekaApplicationsResponse(Map<String, Object> eurekaResponse) {
        KiwiPreconditions.checkArgumentNotNull(eurekaResponse, (String)"Eureka applications response must not be null");
        Map applications = (Map)eurekaResponse.get("applications");
        Preconditions.checkState((boolean)Objects.nonNull(applications), (Object)"Eureka data must contain a key 'applications' that contains a Map<String, Object>");
        Object applicationOrApplicationList = applications.get("application");
        ArrayList<EurekaInstance> eurekaInstances = new ArrayList<EurekaInstance>();
        if (Objects.nonNull(applicationOrApplicationList)) {
            if (applicationOrApplicationList instanceof List) {
                for (Map application : (List)applicationOrApplicationList) {
                    Object instances = application.get(INSTANCE_KEY);
                    eurekaInstances.addAll(EurekaResponseParser.parseInstances(instances));
                }
            } else {
                eurekaInstances.addAll(EurekaResponseParser.parseInstances(((Map)applicationOrApplicationList).get(INSTANCE_KEY)));
            }
        }
        return eurekaInstances;
    }

    private static List<EurekaInstance> parseInstances(Object instanceOrInstanceList) {
        KiwiPreconditions.checkArgumentNotNull((Object)instanceOrInstanceList, (String)"Instance data from Eureka can not be null");
        if (instanceOrInstanceList instanceof List) {
            List instanceList = (List)instanceOrInstanceList;
            return instanceList.stream().map(EurekaResponseParser::buildInstance).toList();
        }
        Map instance = (Map)instanceOrInstanceList;
        return Lists.newArrayList((Object[])new EurekaInstance[]{EurekaResponseParser.buildInstance(instance)});
    }

    public static EurekaInstance parseEurekaInstanceResponse(Map<String, Object> eurekaResponse) {
        KiwiPreconditions.checkArgumentNotNull(eurekaResponse, (String)"Eureka instance response must not be null");
        Object instanceObj = eurekaResponse.get(INSTANCE_KEY);
        Preconditions.checkState((boolean)(instanceObj instanceof Map), (Object)"Eureka data must contain a key 'instance' that contains a Map<String, Object>");
        Map instance = (Map)instanceObj;
        return EurekaResponseParser.buildInstance(instance);
    }

    private static EurekaInstance buildInstance(Map<String, Object> instanceData) {
        Map portMap = (Map)instanceData.get("port");
        Map securePortMap = (Map)instanceData.get("securePort");
        Map metadataMap = (Map)instanceData.get("metadata");
        Map leaseInfoMap = (Map)instanceData.get("leaseInfo");
        Map<String, Object> leaseInfo = EurekaResponseParser.extractLeaseInfo(leaseInfoMap);
        String statusUrl = EurekaResponseParser.getStringOrNull(instanceData, "statusPageUrl");
        String healthCheckUrl = EurekaResponseParser.getStringOrNull(instanceData, "healthCheckUrl");
        String url = (String)KiwiObjects.firstNonNullOrNull((Object)statusUrl, (Object)healthCheckUrl, (Object[])new String[0]);
        int adminPort = EurekaResponseParser.getAdminPort(url);
        return EurekaInstance.builder().vipAddress(EurekaResponseParser.getStringOrNull(instanceData, "vipAddress")).secureVipAddress(EurekaResponseParser.getStringOrNull(instanceData, "vipAddress")).app(EurekaResponseParser.getStringOrNull(instanceData, "app")).hostName(EurekaResponseParser.getStringOrNull(instanceData, "hostName")).ipAddr(EurekaResponseParser.getStringOrNull(instanceData, "ipAddr")).status(EurekaResponseParser.getStringOrNull(instanceData, "status")).homePageUrl(EurekaResponseParser.getStringOrNull(instanceData, "homePageUrl")).healthCheckUrl(healthCheckUrl).statusPageUrl(statusUrl).port(portMap).securePort(securePortMap).adminPort(adminPort).leaseInfo(leaseInfo).metadata(metadataMap).rawResponse(instanceData).build();
    }

    private static Map<String, Object> extractLeaseInfo(Map<String, Object> leaseInfoMap) {
        if (Objects.nonNull(leaseInfoMap)) {
            return Map.of("renewalIntervalInSecs", leaseInfoMap.getOrDefault("renewalIntervalInSecs", 0), "durationInSecs", leaseInfoMap.getOrDefault("durationInSecs", 0), "registrationTimestamp", leaseInfoMap.getOrDefault("registrationTimestamp", 0L), "lastRenewalTimestamp", leaseInfoMap.getOrDefault("lastRenewalTimestamp", 0L), "evictionTimestamp", leaseInfoMap.getOrDefault("evictionTimestamp", 0L), "serviceUpTimestamp", leaseInfoMap.getOrDefault("serviceUpTimestamp", 0L));
        }
        return Map.of();
    }

    private static <K> String getStringOrNull(Map<? super K, ?> map, K key) {
        Object value = map.getOrDefault(key, null);
        Verify.verify((Objects.isNull(value) || value instanceof String ? 1 : 0) != 0, (String)"Value from Map must be a string or null", (Object[])new Object[0]);
        return value;
    }

    @VisibleForTesting
    static int getAdminPort(@Nullable String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return 0;
        }
        return KiwiInternetAddresses.portFrom((String)url).orElseGet(() -> EurekaResponseParser.defaultPortForScheme(url));
    }

    private static int defaultPortForScheme(String url) {
        return url.startsWith("https") ? 443 : 80;
    }

    @Generated
    private EurekaResponseParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

