/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.registry.eureka.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.base.KiwiPreconditions;
import org.kiwiproject.jackson.ser.ListToCsvStringDeserializer;
import org.kiwiproject.net.KiwiUrls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class EurekaConfig {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(EurekaConfig.class);
    private static final String DEFAULT_RETRY_ID_PREFIX = "EurekaRegistryClient-";
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    @JsonDeserialize(using=ListToCsvStringDeserializer.class)
    private String registryUrls;
    private String domainOverride;
    private boolean includeNativeData;
    private String retryId = EurekaConfig.retryId(INSTANCE_COUNT.incrementAndGet());
    private Level retryProcessingLogLevel = Level.DEBUG;
    private Level retryExceptionLogLevel = Level.WARN;

    @NotBlank
    public String getRegistryUrls() {
        String adjustedUrls = StringUtils.isBlank((CharSequence)this.domainOverride) ? this.registryUrls : KiwiUrls.replaceDomainsIn((String)this.registryUrls, (String)this.domainOverride);
        this.logWarningIfDomainOverrideIsSet();
        return adjustedUrls;
    }

    public void setRegistryUrls(String urlCsv) {
        this.registryUrls = urlCsv;
    }

    public void setRegistryUrls(List<String> urls) {
        this.registryUrls = String.join((CharSequence)",", urls);
    }

    private void logWarningIfDomainOverrideIsSet() {
        if (StringUtils.isNotBlank((CharSequence)this.domainOverride)) {
            LOG.warn("The 'domainOverride' parameter supersedes 'registryUrls'. Both are currently set in YAML config");
        }
    }

    public void setRetryId(String id) {
        this.retryId = EurekaConfig.retryId(id);
    }

    public static String retryId(Object identifier) {
        KiwiPreconditions.checkArgumentNotNull((Object)identifier, (String)"identifier must not be null");
        String idString = identifier.toString();
        if (idString.startsWith(DEFAULT_RETRY_ID_PREFIX)) {
            return idString;
        }
        return DEFAULT_RETRY_ID_PREFIX + idString;
    }

    @Generated
    public String getDomainOverride() {
        return this.domainOverride;
    }

    @Generated
    public boolean isIncludeNativeData() {
        return this.includeNativeData;
    }

    @Generated
    public String getRetryId() {
        return this.retryId;
    }

    @Generated
    public Level getRetryProcessingLogLevel() {
        return this.retryProcessingLogLevel;
    }

    @Generated
    public Level getRetryExceptionLogLevel() {
        return this.retryExceptionLogLevel;
    }

    @Generated
    public void setDomainOverride(String domainOverride) {
        this.domainOverride = domainOverride;
    }

    @Generated
    public void setIncludeNativeData(boolean includeNativeData) {
        this.includeNativeData = includeNativeData;
    }

    @Generated
    public void setRetryProcessingLogLevel(Level retryProcessingLogLevel) {
        this.retryProcessingLogLevel = retryProcessingLogLevel;
    }

    @Generated
    public void setRetryExceptionLogLevel(Level retryExceptionLogLevel) {
        this.retryExceptionLogLevel = retryExceptionLogLevel;
    }
}

