/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.check.CommonProperties;
import org.klojang.collections.CrisprList;
import org.klojang.collections.WiredIterator;
import org.klojang.collections.WiredList;
import org.klojang.util.ArrayMethods;
import org.klojang.util.CollectionMethods;
import org.klojang.util.InvokeMethods;

abstract sealed class AbstractLinkedList<E>
implements List<E>
permits WiredList, CrisprList {
    final String className = this.getClass().getSimpleName();
    Node<E> head;
    Node<E> tail;
    int sz;

    AbstractLinkedList() {
    }

    static Supplier<IllegalArgumentException> autoEmbedNotAllowed() {
        return () -> new IllegalArgumentException("list cannot be embedded within itself");
    }

    static Supplier<IllegalStateException> callNextFirst() {
        return () -> new IllegalStateException("Iterator.next() must be called first");
    }

    static Supplier<IllegalStateException> emptyList() {
        return () -> new IllegalStateException("illegal operation on empty list");
    }

    static Function<String, IllegalArgumentException> emptySegment() {
        return s -> new IllegalArgumentException("zero-length segment not allowed");
    }

    static Supplier<ConcurrentModificationException> concurrentModification() {
        return ConcurrentModificationException::new;
    }

    static Function<String, IllegalArgumentException> overlapNotAllowed() {
        return s -> new IllegalArgumentException("list segments must not overlap");
    }

    @Override
    public int indexOf(Object o) {
        Node<Object> n = this.head;
        if (o == null) {
            for (int i = 0; i < this.sz; ++i) {
                if (n.val == null) {
                    return i;
                }
                n = n.next;
            }
        } else {
            for (int i = 0; i < this.sz; ++i) {
                if (o.equals(n.val)) {
                    return i;
                }
                n = n.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Node<Object> n = this.tail;
        if (o == null) {
            for (int i = this.sz - 1; i >= 0; --i) {
                if (n.val == null) {
                    return i;
                }
                n = n.prev;
            }
        } else {
            for (int i = this.sz - 1; i >= 0; --i) {
                if (o.equals(n.val)) {
                    return i;
                }
                n = n.prev;
            }
        }
        return -1;
    }

    @Override
    public E get(int index) {
        return (E)this.node((int)index).val;
    }

    @Override
    public E set(int index, E element) {
        Node<E> node = this.node(index);
        Object old = node.val;
        node.val = element;
        return (E)old;
    }

    @Override
    public boolean add(E e) {
        Node<E> n = new Node<E>(e);
        if (this.sz == 0) {
            this.tail = n;
            this.head = this.tail;
        } else {
            AbstractLinkedList.join(this.tail, n);
            this.tail = n;
        }
        ++this.sz;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkInclusive(index);
        this.insert(index, new Node<E>(element));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.sz, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkInclusive(index);
        Check.notNull(c, (String)"collection");
        if (!c.isEmpty()) {
            this.insert(index, Chain.of(c));
        }
        return !c.isEmpty();
    }

    @Override
    public int size() {
        return this.sz;
    }

    @Override
    public boolean isEmpty() {
        return this.sz == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Check.notNull(c);
        return new HashSet(this).containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Check.notNull(c, (String)"collection");
        int size = this.sz;
        this.removeIf(c::contains);
        return size != this.sz;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Check.notNull(c, (String)"collection");
        int size = this.sz;
        this.removeIf(e -> !c.contains(e));
        return size != this.sz;
    }

    @Override
    public Iterator<E> iterator() {
        return this.sz == 0 ? Collections.emptyIterator() : new Iterator<E>(){
            private Node<E> curr;
            {
                this.curr = AbstractLinkedList.this.justBeforeHead();
            }

            @Override
            public boolean hasNext() {
                return this.curr != AbstractLinkedList.this.tail;
            }

            @Override
            public E next() {
                Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.tail, CommonExceptions.noSuchElement());
                this.curr = this.curr.next;
                return Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
            }
        };
    }

    Iterator<E> reverseIterator0() {
        return this.sz == 0 ? Collections.emptyIterator() : new Iterator<E>(){
            private Node<E> curr;
            {
                this.curr = AbstractLinkedList.this.justAfterTail();
            }

            @Override
            public boolean hasNext() {
                return this.curr != AbstractLinkedList.this.head;
            }

            @Override
            public E next() {
                Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.head, CommonExceptions.noSuchElement());
                this.curr = this.curr.prev;
                return Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.isEmpty() ? Collections.emptyListIterator() : new ListItr();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.checkInclusive(index);
        if (this.isEmpty()) {
            return Collections.emptyListIterator();
        }
        return new ListItr(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof List) {
            List l = (List)o;
            if (this.sz == 0) {
                return l.size() == 0;
            }
            if (this.sz == l.size()) {
                Node<Object> x = this.head;
                for (Object obj : l) {
                    if (!Objects.equals(obj, x.val)) {
                        return false;
                    }
                    x = x.next;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        for (E val : this) {
            hash = 31 * hash + Objects.hashCode(val);
        }
        return hash;
    }

    public String toString() {
        return "[" + CollectionMethods.implode((Collection)this) + "]";
    }

    @SafeVarargs
    final void set0(int index, E e0, E e1, E ... moreElems) {
        Check.that((int)index).is(CommonChecks.indexInclusiveOf(), (Object)this, CommonExceptions.indexOutOfBounds((int)index));
        Check.notNull(moreElems, (String)"varargs array").has(CommonProperties.length(), CommonChecks.lte(), this.sz - index - 2);
        Node<Object> node = this.nodeAt(index);
        node.val = e0;
        node = node.next;
        node.val = e1;
        if (moreElems.length != 0) {
            node = node.next;
            for (E e : moreElems) {
                node.val = e;
                node = node.next;
            }
        }
    }

    final E setIf0(int index, Predicate<? super E> condition, E value) {
        Check.notNull(condition, (String)"test");
        Node<E> node = this.node(index);
        Object old = node.val;
        if (condition.test(old)) {
            node.val = value;
        }
        return (E)old;
    }

    final void prepend0(E value) {
        Node<E> n = new Node<E>(value);
        if (this.sz == 0) {
            this.tail = n;
            this.head = this.tail;
        } else {
            AbstractLinkedList.join(n, this.head);
            this.head = n;
        }
        ++this.sz;
    }

    final void replaceAll0(int fromIndex, int toIndex, Collection<? extends E> values) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull(values, (String)"collection");
        if (len == 0) {
            if (!values.isEmpty()) {
                this.insert(fromIndex, Chain.of(values));
            }
        } else if (len == values.size()) {
            Node<Object> node = this.nodeAt(fromIndex);
            for (E e : values) {
                node.val = e;
                node = node.next;
            }
        } else {
            this.unlink(fromIndex, toIndex);
            if (!values.isEmpty()) {
                this.insert(fromIndex, Chain.of(values));
            }
        }
    }

    final void reverse0() {
        if (this.sz > 1) {
            Node<Object> x = this.head;
            Node<Object> y = this.tail;
            for (int i = 0; i < this.sz / 2; ++i) {
                Object tmp = x.val;
                x.val = y.val;
                y.val = tmp;
                x = x.next;
                y = y.prev;
            }
        }
    }

    final void swap0(int from1, int to1, int from2, int to2) {
        int y1;
        int y0;
        int x1;
        int x0;
        int len1 = Check.fromTo((List)this, (int)from1, (int)to1);
        int len2 = Check.fromTo((List)this, (int)from2, (int)to2);
        Check.on(AbstractLinkedList.emptySegment(), (int)len1).is(CommonChecks.ne(), 0).and(len2).is(CommonChecks.ne(), 0);
        if (from1 < from2) {
            x0 = from1;
            x1 = to1;
            y0 = from2;
            y1 = to2;
        } else {
            x0 = from2;
            x1 = to2;
            y0 = from1;
            y1 = to1;
        }
        Check.on(AbstractLinkedList.overlapNotAllowed(), (int)x1).is(CommonChecks.lte(), y0);
        Node<E> seg1L = this.nodeAt(x0);
        Node<E> seg1R = this.nodeAfter(seg1L, x0, x1 - 1);
        Node<E> seg2L = this.nodeAfter(seg1R, x1 - 1, y0);
        Node<E> seg2R = this.nodeAfter(seg2L, y0, y1 - 1);
        if (x1 == y0) {
            if (seg2R == this.tail) {
                this.makeTail(seg1R);
            } else {
                AbstractLinkedList.join(seg1R, seg2R.next);
            }
            if (seg1L == this.head) {
                this.makeHead(seg2L);
            } else {
                AbstractLinkedList.join(seg1L.prev, seg2L);
            }
            AbstractLinkedList.join(seg2R, seg1L);
        } else {
            if (seg1L == this.head) {
                this.head = seg2L;
            } else {
                seg1L.prev.next = seg2L;
            }
            if (seg2R == this.tail) {
                this.tail = seg1R;
            } else {
                seg2R.next.prev = seg1R;
            }
            seg1R.next.prev = seg2R;
            seg2L.prev.next = seg1L;
            Node tmp = seg1L.prev;
            seg1L.prev = seg2L.prev;
            seg2L.prev = tmp;
            tmp = seg1R.next;
            seg1R.next = seg2R.next;
            seg2R.next = tmp;
        }
    }

    void moveRight(int from, int to, int newFrom) {
        int indexOfLast = to - 1;
        int steps = newFrom - from;
        Node<E> first = this.nodeAt(from);
        Node<E> last = this.nodeAfter(first, from, indexOfLast);
        Node<E> insertAfter = this.nodeAfter(last, indexOfLast, indexOfLast + steps);
        if (first == this.head) {
            this.makeHead(last.next);
        } else {
            AbstractLinkedList.join(first.prev, last.next);
        }
        if (insertAfter == this.tail) {
            AbstractLinkedList.join(insertAfter, first);
            this.makeTail(last);
        } else {
            AbstractLinkedList.join(last, insertAfter.next);
            AbstractLinkedList.join(insertAfter, first);
        }
    }

    void moveLeft(int from, int to, int newFrom) {
        Node<E> first = this.nodeAt(from);
        Node<E> last = this.nodeAfter(first, from, to - 1);
        Node<E> insertBefore = this.nodeBefore(first, from, newFrom);
        if (last == this.tail) {
            this.makeTail(first.prev);
        } else {
            AbstractLinkedList.join(first.prev, last.next);
        }
        if (insertBefore == this.head) {
            AbstractLinkedList.join(last, insertBefore);
            this.makeHead(first);
        } else {
            AbstractLinkedList.join(insertBefore.prev, first);
            AbstractLinkedList.join(last, insertBefore);
        }
    }

    @Override
    public Object[] toArray() {
        if (this.sz == 0) {
            return ArrayMethods.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[this.sz];
        Node<Object> node = this.head;
        for (int i = 0; i < this.sz; ++i) {
            result[i] = node.val;
            node = node.next;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Check.notNull(a);
        if (a.length < this.sz) {
            a = (Object[])InvokeMethods.newArray(a.getClass(), (int)this.sz);
        }
        T[] result = a;
        Node<Object> node = this.head;
        for (int i = 0; i < this.sz; ++i) {
            result[i] = node.val;
            node = node.next;
        }
        if (a.length > this.sz) {
            a[this.sz] = null;
        }
        return a;
    }

    final Object[] regionToArray0(int fromIndex, int toIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        if (len == 0) {
            return ArrayMethods.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[len];
        Node<Object> node = this.nodeAt(fromIndex);
        for (int i = 0; i < len; ++i) {
            result[i] = node.val;
            node = node.next;
        }
        return result;
    }

    final void regionToArray0(int fromIndex, int toIndex, Object[] target, int offset) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull((Object)target, (String)"target").has(CommonProperties.length(), CommonChecks.gte(), len + offset);
        Check.that((int)offset, (String)"offset").is(CommonChecks.gte(), 0);
        if (len != 0) {
            Node<Object> node = this.nodeAt(fromIndex);
            for (int i = 0; i < len; ++i) {
                target[offset++] = node.val;
                node = node.next;
            }
        }
    }

    void insert(int index, Node node) {
        if (this.sz == 0) {
            this.makeHead(node);
            this.makeTail(node);
        } else if (index == 0) {
            AbstractLinkedList.join(node, this.head);
            this.makeHead(node);
        } else if (index == this.sz) {
            AbstractLinkedList.join(this.tail, node);
            this.makeTail(node);
        } else {
            Node<E> x = this.nodeAt(index);
            AbstractLinkedList.join(x.prev, node);
            AbstractLinkedList.join(node, x);
        }
        ++this.sz;
    }

    void insert(int index, Chain chain) {
        if (this.sz == 0) {
            this.makeHead(chain.head);
            this.makeTail(chain.tail);
        } else if (index == 0) {
            AbstractLinkedList.join(chain.tail, this.head);
            this.makeHead(chain.head);
        } else if (index == this.sz) {
            AbstractLinkedList.join(this.tail, chain.head);
            this.makeTail(chain.tail);
        } else {
            Node<E> node = this.nodeAt(index);
            AbstractLinkedList.join(node.prev, chain.head);
            if (chain.length == 1) {
                AbstractLinkedList.join(chain.head, node);
            } else {
                AbstractLinkedList.join(chain.tail, node);
            }
        }
        this.sz += chain.length;
    }

    void unlink(Node<E> node) {
        if (this.sz == 1) {
            this.tail = null;
            this.head = null;
        } else if (node == this.head) {
            this.makeHead(node.next);
        } else if (node == this.tail) {
            this.makeTail(node.prev);
        } else {
            AbstractLinkedList.join(node.prev, node.next);
        }
        --this.sz;
    }

    Chain unlink(int from, int to) {
        Node<E> first = this.nodeAt(from);
        Node<E> last = this.nodeAfter(first, from, to - 1);
        return this.unlink(new Chain(first, last, to - from));
    }

    Chain unlink(Chain chain) {
        if (chain.length == this.sz) {
            this.tail = null;
            this.head = null;
        } else if (chain.head == this.head) {
            this.makeHead(chain.tail.next);
        } else if (chain.tail == this.tail) {
            this.makeTail(chain.head.prev);
        } else {
            AbstractLinkedList.join(chain.head.prev, chain.tail.next);
        }
        this.sz -= chain.length;
        return chain;
    }

    Node<E> node(int index) {
        return (Node)Check.that((int)index).is(CommonChecks.indexExclusiveOf(), (Object)this, CommonExceptions.indexOutOfBounds((int)index)).mapToObj(this::nodeAt);
    }

    Node<E> nodeAt(int index) {
        if (index < this.sz >> 1) {
            Node<Object> n = this.head;
            for (int i = 0; i < index; ++i) {
                n = n.next;
            }
            return n;
        }
        Node<Object> n = this.tail;
        for (int i = this.sz - 1; i > index; --i) {
            n = n.prev;
        }
        return n;
    }

    Node<E> nodeAfter(Node<E> startNode, int startIndex, int index) {
        Node<Object> n;
        if (index < this.sz + startIndex >> 1) {
            n = startNode;
            while (startIndex++ < index) {
                n = n.next;
            }
        } else {
            n = this.tail;
            while (++index < this.sz) {
                n = n.prev;
            }
        }
        return n;
    }

    Node<E> nodeBefore(Node<E> startNode, int startIndex, int index) {
        Node<Object> n;
        if (index < startIndex >> 1) {
            n = this.head;
            while (index-- > 0) {
                n = n.next;
            }
        } else {
            n = startNode;
            while (index++ < startIndex) {
                n = n.prev;
            }
        }
        return n;
    }

    void makeHead(Node<E> node) {
        node.prev = null;
        this.head = node;
    }

    void makeTail(Node<E> node) {
        node.next = null;
        this.tail = node;
    }

    static <T> void join(Node<T> prev, Node<T> next) {
        prev.next = next;
        next.prev = prev;
    }

    Node<E> justBeforeHead() {
        Node<Object> x = new Node<Object>(null);
        x.next = this.head;
        return x;
    }

    Node<E> justAfterTail() {
        Node<Object> x = new Node<Object>(null);
        x.prev = this.tail;
        return x;
    }

    void checkInclusive(int index) {
        Check.that((int)index).is(CommonChecks.indexInclusiveOf(), (Object)this, CommonExceptions.indexOutOfBounds((int)index));
    }

    static final class Node<V> {
        V val;
        Node<V> prev;
        Node<V> next;

        Node(V val) {
            this.val = val;
        }

        Node(Node<V> prev, V val) {
            this.prev = prev;
            this.val = val;
            prev.next = this;
        }

        V value() {
            return this.val;
        }

        public String toString() {
            return String.valueOf(this.val);
        }
    }

    static final class Chain {
        final Node head;
        final Node tail;
        final int length;

        static <V> Chain of(Collection<V> values) {
            Node<V> head;
            if (values instanceof AbstractLinkedList) {
                AbstractLinkedList l = (AbstractLinkedList)values;
                return Chain.copyOf(l.head, l.size());
            }
            Iterator<V> itr = values.iterator();
            Node<V> tail = head = new Node<V>(itr.next());
            while (itr.hasNext()) {
                tail = new Node<V>(tail, itr.next());
            }
            return new Chain(head, tail, values.size());
        }

        static Chain copyOf(Node node, int len) {
            Node head;
            Node tail = head = new Node(node.val);
            for (int i = 1; i < len; ++i) {
                node = node.next;
                tail = new Node(tail, node.val);
            }
            return new Chain(head, tail, len);
        }

        Chain(Node head, Node tail, int length) {
            this.head = head;
            this.tail = tail;
            this.length = length;
        }
    }

    class ListItr
    implements ListIterator<E> {
        Node<E> curr;
        Boolean forward;
        int idx;

        ListItr() {
            this.curr = AbstractLinkedList.this.head;
            this.idx = 0;
        }

        ListItr(int index) {
            this.idx = index;
            this.curr = this.idx == AbstractLinkedList.this.sz ? null : AbstractLinkedList.this.nodeAt(index);
        }

        @Override
        public boolean hasNext() {
            return this.forward == null && AbstractLinkedList.this.sz != 0 || this.curr != AbstractLinkedList.this.tail;
        }

        @Override
        public E next() {
            if (this.forward == Boolean.TRUE) {
                Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.tail, CommonExceptions.noSuchElement());
                Check.that((int)(++this.idx)).is(CommonChecks.lt(), AbstractLinkedList.this.sz, AbstractLinkedList.concurrentModification());
                this.curr = this.curr.next;
                return Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
            }
            this.forward = Boolean.TRUE;
            return this.curr.val;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr != AbstractLinkedList.this.head;
        }

        @Override
        public E previous() {
            Object val;
            if (this.idx == AbstractLinkedList.this.sz) {
                Check.that((int)(--this.idx)).is(CommonChecks.gte(), 0, AbstractLinkedList.concurrentModification());
                this.curr = AbstractLinkedList.this.tail;
                val = Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
            } else if (this.forward != Boolean.TRUE) {
                Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.head, CommonExceptions.noSuchElement());
                Check.that((int)(--this.idx)).is(CommonChecks.gte(), 0, AbstractLinkedList.concurrentModification());
                this.curr = this.curr.prev;
                val = Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
            } else {
                val = this.curr.val;
            }
            this.forward = Boolean.FALSE;
            return val;
        }

        @Override
        public int nextIndex() {
            return this.forward == Boolean.TRUE ? this.idx + 1 : this.idx;
        }

        @Override
        public int previousIndex() {
            return this.forward == Boolean.TRUE ? this.idx : this.idx - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E value) {
            throw new UnsupportedOperationException();
        }
    }

    abstract sealed class ReverseWiredIterator
    implements WiredIterator<E>
    permits CrisprList.CRevWiredIterator, WiredList.WRevWiredIterator {
        Node<E> afterTail;
        Node<E> curr;

        ReverseWiredIterator() {
            this.afterTail = AbstractLinkedList.this.justAfterTail();
            this.curr = this.afterTail;
        }

        ReverseWiredIterator(Node<E> curr) {
            this.curr = curr;
        }

        @Override
        public boolean hasNext() {
            return AbstractLinkedList.this.sz != 0 && this.curr != AbstractLinkedList.this.head;
        }

        @Override
        public E value() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            return this.curr.val;
        }

        @Override
        public E peek() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.head, CommonExceptions.noSuchElement());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
            return Check.that(this.curr.prev).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
        }

        @Override
        public E next() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.head, CommonExceptions.noSuchElement());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
            this.curr = this.curr.prev;
            return Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
        }

        @Override
        public void set(E newVal) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            this.curr.val = newVal;
        }

        @Override
        public void insertBefore(E value) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            Node node = new Node(value);
            if (this.curr == AbstractLinkedList.this.tail) {
                AbstractLinkedList.this.tail = node;
                AbstractLinkedList.join(this.curr, AbstractLinkedList.this.tail);
            } else {
                Check.that(this.curr.next).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification());
                AbstractLinkedList.join(node, this.curr.next);
                AbstractLinkedList.join(this.curr, node);
            }
            ++AbstractLinkedList.this.sz;
        }

        @Override
        public void insertAfter(E value) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            Node node = new Node(value);
            if (this.curr == AbstractLinkedList.this.head) {
                AbstractLinkedList.this.head = node;
                AbstractLinkedList.join(AbstractLinkedList.this.head, this.curr);
            } else {
                Check.that(this.curr.prev).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification());
                AbstractLinkedList.join(this.curr.prev, node);
                AbstractLinkedList.join(node, this.curr);
            }
            ++AbstractLinkedList.this.sz;
        }

        @Override
        public int index() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            int idx = AbstractLinkedList.this.sz - 1;
            Node node = AbstractLinkedList.this.tail;
            while (node != this.curr) {
                node = (Node)Check.that(node).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.head, AbstractLinkedList.concurrentModification()).ok(x -> x.prev);
                --idx;
            }
            return idx;
        }

        @Override
        public WiredIterator<E> turn() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            return this.getForwardWiredIterator(this.curr);
        }

        abstract WiredIterator<E> getForwardWiredIterator(Node<E> var1);
    }

    abstract sealed class ForwardWiredIterator
    implements WiredIterator<E>
    permits CrisprList.CFwdWiredIterator, WiredList.WFwdWiredIterator {
        Node<E> beforeHead;
        Node<E> curr;

        ForwardWiredIterator() {
            this.beforeHead = AbstractLinkedList.this.justBeforeHead();
            this.curr = this.beforeHead;
        }

        ForwardWiredIterator(Node<E> curr) {
            this.curr = curr;
        }

        @Override
        public boolean hasNext() {
            return AbstractLinkedList.this.sz != 0 && this.curr != AbstractLinkedList.this.tail;
        }

        @Override
        public E value() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            return this.curr.val;
        }

        @Override
        public E peek() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.tail, CommonExceptions.noSuchElement());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
            return Check.that(this.curr.next).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
        }

        @Override
        public E next() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.tail, CommonExceptions.noSuchElement());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
            this.curr = this.curr.next;
            return Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).ok(Node::value);
        }

        @Override
        public void set(E newVal) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            this.curr.val = newVal;
        }

        @Override
        public void insertBefore(E value) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            Node node = new Node(value);
            if (this.curr == AbstractLinkedList.this.head) {
                AbstractLinkedList.this.head = node;
                AbstractLinkedList.join(AbstractLinkedList.this.head, this.curr);
            } else {
                Check.that(this.curr.prev).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification());
                AbstractLinkedList.join(this.curr.prev, node);
                AbstractLinkedList.join(node, this.curr);
            }
            ++AbstractLinkedList.this.sz;
        }

        @Override
        public void insertAfter(E value) {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            Node node = new Node(value);
            if (this.curr == AbstractLinkedList.this.tail) {
                AbstractLinkedList.this.tail = node;
                AbstractLinkedList.join(this.curr, AbstractLinkedList.this.tail);
            } else {
                Check.that(this.curr.next).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification());
                AbstractLinkedList.join(node, this.curr.next);
                AbstractLinkedList.join(this.curr, node);
            }
            ++AbstractLinkedList.this.sz;
        }

        @Override
        public int index() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            int idx = 0;
            Node node = AbstractLinkedList.this.head;
            while (node != this.curr) {
                node = (Node)Check.that(node).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).isNot(CommonChecks.sameAs(), AbstractLinkedList.this.tail, AbstractLinkedList.concurrentModification()).ok(x -> x.next);
                ++idx;
            }
            return idx;
        }

        @Override
        public WiredIterator<E> turn() {
            Check.that(this.curr).isNot(CommonChecks.sameAs(), this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)AbstractLinkedList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            return this.getReverseWiredIterator(this.curr);
        }

        abstract WiredIterator<E> getReverseWiredIterator(Node<E> var1);
    }
}

