/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Comparator;
import org.klojang.util.ClassMethods;

final class BasicTypeComparator
implements Comparator<Class<?>> {
    BasicTypeComparator() {
    }

    @Override
    public int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == Object.class) {
            return 1;
        }
        if (c2 == Object.class) {
            return -1;
        }
        if (c1.isInterface()) {
            int x;
            if (c2.isInterface() && (x = BasicTypeComparator.countInterfaces(c2) - BasicTypeComparator.countInterfaces(c1)) != 0) {
                return x;
            }
            return 1;
        }
        if (c2.isInterface()) {
            return -1;
        }
        int x = ClassMethods.countAncestors(c2) - ClassMethods.countAncestors(c1);
        if (x != 0) {
            return x;
        }
        x = BasicTypeComparator.countInterfaces(c2) - BasicTypeComparator.countInterfaces(c1);
        if (x != 0) {
            return x;
        }
        if (c1.isArray() && c2.isArray()) {
            return this.compare(c1.getComponentType(), c2.getComponentType());
        }
        return c1.hashCode() - c2.hashCode();
    }

    private static int countInterfaces(Class<?> c) {
        return ClassMethods.getAllInterfaces(c).size();
    }
}

