/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.collections.AbstractLinkedList;
import org.klojang.collections.WiredIterator;
import org.klojang.util.MathMethods;

public final class CrisprList<E>
extends AbstractLinkedList<E> {
    public static <E> CrisprList<E> of() {
        return new CrisprList<E>();
    }

    public static <E> CrisprList<E> of(E e) {
        return new CrisprList<E>().append(e);
    }

    public static <E> CrisprList<E> of(E e0, E e1) {
        return new CrisprList<E>().append(e0).append(e1);
    }

    @SafeVarargs
    public static <E> CrisprList<E> of(E e0, E e1, E e2, E ... moreElems) {
        AbstractLinkedList.Node<E> head;
        Check.notNull(moreElems, (String)"array");
        CrisprList<E> cl = new CrisprList<E>();
        AbstractLinkedList.Node<E> tail = head = new AbstractLinkedList.Node<E>(e0);
        tail = new AbstractLinkedList.Node<E>(tail, e1);
        tail = new AbstractLinkedList.Node<E>(tail, e2);
        for (E e : moreElems) {
            tail = new AbstractLinkedList.Node<E>(tail, e);
        }
        cl.head = head;
        cl.tail = tail;
        cl.sz = moreElems.length + 3;
        return cl;
    }

    public static <E> CrisprList<E> ofElements(E[] elements) {
        Check.notNull(elements, (String)"array");
        CrisprList<E> cl = new CrisprList<E>();
        if (elements.length != 0) {
            AbstractLinkedList.Node<E> head;
            AbstractLinkedList.Node<E> tail = head = new AbstractLinkedList.Node<E>(elements[0]);
            for (int i = 1; i < elements.length; ++i) {
                tail = new AbstractLinkedList.Node<E>(tail, elements[i]);
            }
            cl.head = head;
            cl.tail = tail;
            cl.sz = elements.length;
        }
        return cl;
    }

    public static <E> CrisprList<E> join(List<CrisprList<E>> lists) {
        CrisprList<E> cl = new CrisprList<E>();
        ((List)Check.notNull(lists).ok()).forEach(cl::attach);
        return cl;
    }

    public CrisprList() {
    }

    public CrisprList(Collection<? extends E> c) {
        this.addAll(0, (Collection)c);
    }

    private CrisprList(AbstractLinkedList.Chain chain) {
        this.makeHead(chain.head);
        this.makeTail(chain.tail);
        this.sz = chain.length;
    }

    public CrisprList<E> set(int index, E e0, E e1, E ... moreElems) {
        this.set0(index, e0, e1, moreElems);
        return this;
    }

    public E setIf(int index, Predicate<? super E> condition, E value) {
        return this.setIf0(index, condition, value);
    }

    @Override
    public E remove(int index) {
        AbstractLinkedList.Node x = this.node(index);
        Object val = x.val;
        this.unlink(x);
        return (E)val;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            AbstractLinkedList.Node x = this.head;
            while (x != null) {
                if (x.val == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            AbstractLinkedList.Node x = this.head;
            while (x != null) {
                if (o.equals(x.val)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Check.notNull(filter, (String)"filter");
        int size = this.sz;
        AbstractLinkedList.Node x = this.head;
        while (x != null) {
            if (filter.test(x.val)) {
                AbstractLinkedList.Node next = x.next;
                this.unlink(x);
                x = next;
                continue;
            }
            x = x.next;
        }
        return size != this.sz;
    }

    public E first() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return (E)this.head.val;
    }

    public E last() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return (E)this.tail.val;
    }

    public CrisprList<E> prepend(E value) {
        this.prepend0(value);
        return this;
    }

    public CrisprList<E> prependAll(Collection<? extends E> values) {
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(0, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    public CrisprList<E> append(E value) {
        this.add((Object)value);
        return this;
    }

    public CrisprList<E> appendAll(Collection<? extends E> values) {
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(this.sz, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    public CrisprList<E> insert(int index, E value) {
        this.checkInclusive(index);
        this.insert(index, new AbstractLinkedList.Node<E>(value));
        return this;
    }

    public CrisprList<E> insertAll(int index, Collection<? extends E> values) {
        this.checkInclusive(index);
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(index, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    @Override
    public E removeFirst() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        Object val = this.head.val;
        this.unlink(this.head);
        return (E)val;
    }

    @Override
    public E removeLast() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        Object val = this.tail.val;
        this.unlink(this.tail);
        return (E)val;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (this.sz != 0) {
            AbstractLinkedList.Node x = this.head;
            while (true) {
                x.val = operator.apply(x.val);
                if (x == this.tail) break;
                x = x.next;
            }
        }
    }

    public CrisprList<E> replaceAll(int fromIndex, int toIndex, Collection<? extends E> values) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull(values, (String)"collection");
        if (len == 0) {
            if (!values.isEmpty()) {
                this.insert(fromIndex, AbstractLinkedList.Chain.of(values));
            }
        } else if (len < values.size()) {
            this.unlink(fromIndex, toIndex);
            if (!values.isEmpty()) {
                this.insert(fromIndex, AbstractLinkedList.Chain.of(values));
            }
        } else {
            AbstractLinkedList.Node<Object> node = this.nodeAt(fromIndex);
            for (E e : values) {
                node.val = e;
                node = node.next;
            }
            if (len > values.size()) {
                AbstractLinkedList.Node end = this.nodeAfter(node, fromIndex + values.size(), toIndex - 1);
                AbstractLinkedList.Chain chain = new AbstractLinkedList.Chain(node, end, len - values.size());
                this.unlink(chain);
            }
        }
        return this;
    }

    public CrisprList<E> replace(int fromIndex, int toIndex, CrisprList<? extends E> other) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull(other, (String)this.className).isNot(CommonChecks.sameAs(), (Object)this, CrisprList.autoEmbedNotAllowed());
        if (len != 0) {
            this.unlink(fromIndex, toIndex);
        }
        if (!other.isEmpty()) {
            this.insert(fromIndex, other.unlink(0, other.sz));
        }
        return this;
    }

    public CrisprList<E> copy() {
        return this.sz > 0 ? new CrisprList<E>(AbstractLinkedList.Chain.copyOf(this.head, this.sz)) : CrisprList.of();
    }

    public CrisprList<E> copy(int fromIndex, int toIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        return len > 0 ? new CrisprList<E>(AbstractLinkedList.Chain.copyOf(this.nodeAt(fromIndex), len)) : CrisprList.of();
    }

    public CrisprList<E> shrink(int fromIndex, int toIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        if (len == 0) {
            this.clear();
        } else if (len != this.sz) {
            AbstractLinkedList.Node x = this.nodeAt(fromIndex);
            AbstractLinkedList.Node y = this.nodeAfter(x, fromIndex, toIndex - 1);
            this.makeHead(x);
            this.makeTail(y);
        }
        return this;
    }

    public CrisprList<E> cut(int fromIndex, int toIndex) {
        if (Check.fromTo((List)this, (int)fromIndex, (int)toIndex) > 0) {
            return new CrisprList<E>(this.unlink(fromIndex, toIndex));
        }
        return CrisprList.of();
    }

    public CrisprList<? super E> paste(CrisprList<? super E> into, int index) {
        return into.embed(index, this);
    }

    public CrisprList<E> embed(int index, CrisprList<? extends E> other) {
        this.checkInclusive(index);
        Check.notNull(other, (String)this.className).isNot(CommonChecks.sameAs(), (Object)this, CrisprList.autoEmbedNotAllowed());
        if (!other.isEmpty()) {
            this.insert(index, new AbstractLinkedList.Chain(other.head, other.tail, other.sz));
            other.clear();
        }
        return this;
    }

    public CrisprList<E> exchange(int myFromIndex, int myToIndex, CrisprList<E> other, int itsFromIndex, int itsToIndex) {
        int len0 = Check.fromTo((List)this, (int)myFromIndex, (int)myToIndex);
        int len1 = Check.fromTo(other, (int)itsFromIndex, (int)itsToIndex);
        Check.that(other).isNot(CommonChecks.sameAs(), (Object)this, CrisprList.autoEmbedNotAllowed());
        if (len0 == 0) {
            if (len1 != 0) {
                this.insert(myFromIndex, other.unlink(itsFromIndex, itsToIndex));
            }
            return this;
        }
        if (len1 == 0) {
            other.insert(itsFromIndex, this.unlink(myFromIndex, myToIndex));
            return this;
        }
        AbstractLinkedList.Node seg0L = this.nodeAt(myFromIndex);
        AbstractLinkedList.Node seg0R = this.nodeAfter(seg0L, myFromIndex, myToIndex - 1);
        AbstractLinkedList.Node seg1L = other.nodeAt(itsFromIndex);
        AbstractLinkedList.Node seg1R = other.nodeAfter(seg1L, itsFromIndex, itsToIndex - 1);
        AbstractLinkedList.Node att0L = seg0L.prev;
        AbstractLinkedList.Node att0R = seg0R.next;
        AbstractLinkedList.Node att1L = seg1L.prev;
        AbstractLinkedList.Node att1R = seg1R.next;
        if (att0L == null) {
            this.makeHead(seg1L);
        } else {
            CrisprList.join(att0L, seg1L);
        }
        if (att0R == null) {
            this.makeTail(seg1R);
        } else {
            CrisprList.join(seg1R, att0R);
        }
        if (att1L == null) {
            other.makeHead(seg0L);
        } else {
            CrisprList.join(att1L, seg0L);
        }
        if (att1R == null) {
            other.makeTail(seg0R);
        } else {
            CrisprList.join(seg0R, att1R);
        }
        this.sz = this.sz - len0 + len1;
        other.sz = other.sz - len1 + len0;
        return this;
    }

    public CrisprList<E> embed(int myIndex, CrisprList<? extends E> other, int itsFromIndex, int itsToIndex) {
        this.checkInclusive(myIndex);
        int len = Check.fromTo(other, (int)itsFromIndex, (int)itsToIndex);
        Check.that(other).isNot(CommonChecks.sameAs(), (Object)this, CrisprList.autoEmbedNotAllowed());
        if (len > 0) {
            this.insert(myIndex, other.unlink(itsFromIndex, itsToIndex));
        }
        return this;
    }

    public CrisprList<E> swap(int from1, int to1, int from2, int to2) {
        this.swap0(from1, to1, from2, to2);
        return this;
    }

    public CrisprList<E> attach(CrisprList<? extends E> other) {
        Check.notNull(other).isNot(CommonChecks.sameAs(), (Object)this, CrisprList.autoEmbedNotAllowed());
        if (other.sz != 0) {
            this.attach0(other);
        }
        return this;
    }

    private void attach0(CrisprList other) {
        if (this.sz == 0) {
            this.head = other.head;
        } else {
            CrisprList.join(this.tail, other.head);
        }
        this.tail = other.tail;
        this.sz += other.sz;
        other.clear();
    }

    public CrisprList<E> defragment(List<Predicate<? super E>> criteria) {
        return this.defragment(true, criteria);
    }

    public CrisprList<E> defragment(boolean keepRemainder, List<Predicate<? super E>> criteria) {
        Check.that(criteria).is((Predicate)CommonChecks.deepNotEmpty());
        CrisprList<CrisprList<E>> groups = this.createGroups(criteria);
        AbstractLinkedList.Chain rest = new AbstractLinkedList.Chain(this.head, this.tail, this.sz);
        this.sz = 0;
        for (CrisprList crisprList : groups) {
            if (crisprList.isEmpty()) continue;
            this.attach0(crisprList);
        }
        if (keepRemainder && rest.length != 0) {
            this.insert(this.sz, rest);
        }
        return this;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 group(Predicate<? super E> criterion) {
        return this.group(Collections.singletonList(criterion));
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 group(List<Predicate<? super E>> criteria) {
        Check.that(criteria).is((Predicate)CommonChecks.deepNotEmpty());
        CrisprList<CrisprList<? super E>> groups = this.createGroups(criteria);
        CrisprList<CrisprList<E>> result = new CrisprList<CrisprList<E>>(groups);
        result.add((Object)this);
        return (L1)result;
    }

    private CrisprList<CrisprList<E>> createGroups(List<Predicate<? super E>> criteria) {
        CrisprList groups = new CrisprList();
        criteria.forEach(c -> groups.append(new CrisprList()));
        AbstractLinkedList.Node node = this.head;
        while (node != null) {
            AbstractLinkedList.Node next = node.next;
            for (int i = 0; i < criteria.size(); ++i) {
                if (!criteria.get(i).test(node.val)) continue;
                this.unlink(node);
                CrisprList cl = (CrisprList)groups.get(i);
                cl.insert(cl.size(), node);
                break;
            }
            node = next;
        }
        return groups;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 partition(int size) {
        Check.that((int)size).is(CommonChecks.gt(), 0);
        CrisprList<CrisprList> partitions = new CrisprList<CrisprList>();
        while (this.sz > size) {
            AbstractLinkedList.Chain chain = new AbstractLinkedList.Chain(this.head, this.nodeAt(size - 1), size);
            partitions.append(new CrisprList<E>(this.unlink(chain)));
        }
        partitions.append(this);
        return (L1)partitions;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 split(int numPartitions) {
        Check.that((int)numPartitions).is(CommonChecks.gt(), 0);
        return this.partition(MathMethods.divUp((int)this.sz, (int)numPartitions));
    }

    public CrisprList<E> lchop(Predicate<? super E> criterion) {
        Check.notNull(criterion);
        if (this.sz == 0) {
            return this;
        }
        AbstractLinkedList.Node first = this.head;
        AbstractLinkedList.Node<Object> last = this.justBeforeHead();
        int len = 0;
        while (criterion.test(last.next.val) && ++len != this.sz) {
            last = last.next;
        }
        if (len == this.sz) {
            return this;
        }
        return new CrisprList<E>(this.unlink(new AbstractLinkedList.Chain(first, last, len)));
    }

    public CrisprList<E> rchop(Predicate<? super E> criterion) {
        Check.notNull(criterion);
        if (this.sz == 0) {
            return this;
        }
        AbstractLinkedList.Node last = this.tail;
        AbstractLinkedList.Node<Object> first = this.justAfterTail();
        int len = 0;
        while (criterion.test(first.prev.val) && ++len != this.sz) {
            first = first.prev;
        }
        if (len == this.sz) {
            return this;
        }
        return new CrisprList<E>(this.unlink(new AbstractLinkedList.Chain(first, last, len)));
    }

    public CrisprList<E> reverse() {
        this.reverse0();
        return this;
    }

    public CrisprList<E> move(int fromIndex, int toIndex, int newFromIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.that((int)newFromIndex, (String)"target index").is(CommonChecks.indexInclusiveOf(), (Object)this);
        if (len != 0) {
            if (newFromIndex > fromIndex) {
                this.moveRight(fromIndex, toIndex, newFromIndex);
            } else if (newFromIndex < fromIndex) {
                this.moveLeft(fromIndex, toIndex, newFromIndex);
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.sz = 0;
    }

    public Iterator<E> reverseIterator() {
        return super.reverseIterator0();
    }

    public WiredIterator<E> wiredIterator() {
        return new CFwdWiredIterator();
    }

    public WiredIterator<E> wiredIterator(boolean reverse) {
        return reverse ? new CRevWiredIterator() : new CFwdWiredIterator();
    }

    public Object[] regionToArray(int fromIndex, int toIndex) {
        return this.regionToArray0(fromIndex, toIndex);
    }

    public void regionToArray(int fromIndex, int toIndex, Object[] target, int offset) {
        this.regionToArray0(fromIndex, toIndex, target, offset);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    final class CFwdWiredIterator
    extends AbstractLinkedList.ForwardWiredIterator {
        private CFwdWiredIterator() {
            super(CrisprList.this);
        }

        private CFwdWiredIterator(AbstractLinkedList.Node<E> curr) {
            super(CrisprList.this, curr);
        }

        @Override
        public void remove() {
            Check.that((Object)this.curr).isNot(CommonChecks.sameAs(), (Object)this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)CrisprList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            if (this.curr == CrisprList.this.head) {
                CrisprList.this.unlink(this.curr);
                this.curr = this.beforeHead = CrisprList.this.justBeforeHead();
            } else {
                this.curr = this.curr.prev;
                Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).then(prev -> CrisprList.this.unlink(prev.next));
            }
        }

        @Override
        WiredIterator<E> getReverseWiredIterator(AbstractLinkedList.Node<E> curr) {
            return new CRevWiredIterator(curr);
        }
    }

    final class CRevWiredIterator
    extends AbstractLinkedList.ReverseWiredIterator {
        private CRevWiredIterator() {
            super(CrisprList.this);
        }

        private CRevWiredIterator(AbstractLinkedList.Node<E> curr) {
            super(CrisprList.this, curr);
        }

        @Override
        public void remove() {
            Check.that((Object)this.curr).isNot(CommonChecks.sameAs(), (Object)this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)CrisprList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            if (this.curr == CrisprList.this.tail) {
                CrisprList.this.unlink(this.curr);
                this.curr = this.afterTail = CrisprList.this.justAfterTail();
            } else {
                this.curr = this.curr.next;
                Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).then(next -> CrisprList.this.unlink(next.prev));
            }
        }

        @Override
        WiredIterator<E> getForwardWiredIterator(AbstractLinkedList.Node<E> curr) {
            return new CFwdWiredIterator(curr);
        }
    }
}

