/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.aux.DuplicateValueException;
import org.klojang.collections.FixedTypeMap;
import org.klojang.collections.TypeMapBuilder;

final class FixedTypeMapBuilder<V>
implements TypeMapBuilder<V> {
    private final HashMap<Class<?>, V> tmp = new HashMap();
    private boolean autobox = true;

    static Supplier<DuplicateValueException> duplicateKey(Class<?> type) {
        return () -> new DuplicateValueException(DuplicateValueException.Usage.KEY, (Object)type);
    }

    FixedTypeMapBuilder() {
    }

    @Override
    public FixedTypeMapBuilder<V> autobox(boolean autobox) {
        this.autobox = autobox;
        return this;
    }

    @Override
    public FixedTypeMapBuilder<V> add(Class<?> type, V value) {
        Check.notNull(type, (String)"type").isNot(CommonChecks.keyIn(), this.tmp, FixedTypeMapBuilder.duplicateKey(type));
        Check.notNull(value, (String)"value");
        this.tmp.put(type, value);
        return this;
    }

    @Override
    public FixedTypeMapBuilder<V> addMultiple(V value, Class<?> ... types) {
        ((Stream)Check.notNull(types, (String)"types").ok(Arrays::stream)).forEach(t -> this.add((Class)t, (Object)value));
        return this;
    }

    @Override
    public FixedTypeMap<V> freeze() {
        return new FixedTypeMap<V>(this.tmp, this.autobox);
    }
}

