/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.ArraySet;
import org.klojang.collections.ImmutableMap;
import org.klojang.collections.TypeMap;
import org.klojang.collections.TypeNode;
import org.klojang.util.ArrayType;
import org.klojang.util.ClassMethods;
import org.klojang.util.CollectionMethods;

final class NativeTypeMap<V>
extends ImmutableMap<Class<?>, V>
implements TypeMap<V> {
    private final boolean autobox;
    private final TypeNode root;
    private final int size;
    private Set<Class<?>> keys;
    private Collection<V> values;
    private Set<Map.Entry<Class<?>, V>> entries;
    private int hash;

    NativeTypeMap(TypeNode root, int size, boolean autobox) {
        this.autobox = autobox;
        this.root = root;
        this.size = size;
    }

    @Override
    public V get(Object key) {
        Object val;
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        if (type.isPrimitive()) {
            val = this.root.getPrimitive(type);
            if (val == null) {
                if (this.autobox) {
                    val = this.root.get(ClassMethods.box((Class)type));
                }
                if (val == null) {
                    val = this.root.value();
                }
            }
        } else if (ClassMethods.isDeeplyPrimitiveArray((Class)type)) {
            val = this.root.getPrimitive(type);
            if (val == null) {
                if (this.autobox) {
                    val = this.root.get(ArrayType.forClass((Class)type).box());
                }
                if (val == null) {
                    val = this.root.value();
                }
            }
        } else {
            val = this.root.get(type);
        }
        return (V)val;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean found;
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        if (this.root.value != null) {
            found = true;
        } else if (type.isPrimitive()) {
            found = this.autobox ? this.containsPrimitiveOrBoxedType(type, ClassMethods.box((Class)type)) : this.containsPrimitiveType(type);
        } else if (ClassMethods.isDeeplyPrimitiveArray((Class)type)) {
            if (this.autobox) {
                Class boxed = ArrayType.forClass((Class)type).box();
                found = this.containsPrimitiveOrBoxedType(type, boxed);
            } else {
                found = this.containsPrimitiveType(type);
            }
        } else if (!type.isInterface()) {
            found = this.containsExactOrSuperType(type, this.root.subclasses);
            if (!found) {
                found = this.containsExactOrSuperType(type, this.root.extensions);
            }
        } else {
            found = this.containsExactOrSuperType(type, this.root.extensions);
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Class<?>> keySet() {
        if (this.keys == null) {
            ArrayList bucket = new ArrayList(this.size);
            if (this.root.value() != null) {
                bucket.add(Object.class);
            }
            this.root.collectTypes(bucket);
            this.keys = ArraySet.copyOf(bucket);
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            ArrayList bucket = new ArrayList(this.size);
            if (this.root.value() != null) {
                bucket.add(this.root.value());
            }
            this.root.collectValues(bucket);
            this.values = ArraySet.copyOf(new HashSet(bucket));
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        if (this.entries == null) {
            ArrayList bucket = new ArrayList(this.size);
            if (this.root.value() != null) {
                bucket.add(new AbstractMap.SimpleImmutableEntry(Object.class, this.root.value()));
            }
            this.root.collectEntries(bucket);
            this.entries = Set.copyOf(bucket);
        }
        return this.entries;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean equals(Object o) {
        Map m;
        if (this == o) {
            return true;
        }
        if (o instanceof Map && this.size == (m = (Map)o).size()) {
            return this.entrySet().equals(m.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.entrySet().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "[" + CollectionMethods.implode(this.entrySet()) + "]";
    }

    private boolean containsPrimitiveType(Class<?> type) {
        for (TypeNode node : this.root.subclasses) {
            if (node.type != type) continue;
            return true;
        }
        return false;
    }

    private boolean containsPrimitiveOrBoxedType(Class<?> primitive, Class<?> boxed) {
        for (TypeNode node : this.root.subclasses) {
            if (node.type != primitive && !ClassMethods.isSupertype(node.type, boxed)) continue;
            return true;
        }
        return false;
    }

    private boolean containsExactOrSuperType(Class<?> type, TypeNode[] nodes) {
        for (TypeNode node : nodes) {
            if (!ClassMethods.isSupertype(node.type, type)) continue;
            return true;
        }
        return false;
    }
}

