/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.BasicTypeComparator;
import org.klojang.collections.FixedTypeMapBuilder;
import org.klojang.collections.TypeMapBuilder;
import org.klojang.collections.TypeTreeMap;

final class TreeTypeMapBuilder<V>
implements TypeMapBuilder<V> {
    private final TreeMap<Class<?>, V> tmp = new TreeMap(new BasicTypeComparator());
    private boolean autobox = true;

    TreeTypeMapBuilder() {
    }

    @Override
    public TreeTypeMapBuilder<V> autobox(boolean autobox) {
        this.autobox = autobox;
        return this;
    }

    @Override
    public TreeTypeMapBuilder<V> add(Class<?> type, V value) {
        Check.notNull(type, (String)"type").isNot(CommonChecks.keyIn(), this.tmp, FixedTypeMapBuilder.duplicateKey(type));
        Check.notNull(value, (String)"value");
        this.tmp.put(type, value);
        return this;
    }

    @Override
    public TreeTypeMapBuilder<V> addMultiple(V value, Class<?> ... types) {
        ((Stream)Check.notNull(types, (String)"types").ok(Arrays::stream)).forEach(t -> this.add((Class)t, (Object)value));
        return this;
    }

    @Override
    public TypeTreeMap<V> freeze() {
        return new TypeTreeMap<V>(this.tmp, this.autobox);
    }
}

