/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Map;
import org.klojang.check.Check;
import org.klojang.collections.FixedTypeMapBuilder;
import org.klojang.collections.GreedyTypeMap;
import org.klojang.collections.GreedyTypeMapBuilder;
import org.klojang.collections.NativeTypeMap;
import org.klojang.collections.NativeTypeMapBuilder;
import org.klojang.collections.NonExpandingTypeMap;
import org.klojang.collections.TreeTypeMapBuilder;
import org.klojang.collections.TypeMapBuilder;

public sealed interface TypeMap<V>
extends Map<Class<?>, V>
permits NativeTypeMap, GreedyTypeMap, NonExpandingTypeMap {
    public static final String SOURCE_MAP = "source map";

    public static <V> TypeMap<V> fixedTypeMap(Map<Class<?>, V> m) {
        return TypeMap.fixedTypeMap(m, true);
    }

    public static <V> TypeMap<V> fixedTypeMap(Map<Class<?>, V> m, boolean autobox) {
        Check.notNull(m, (String)SOURCE_MAP);
        TypeMapBuilder builder = new FixedTypeMapBuilder().autobox(autobox);
        m.forEach(((FixedTypeMapBuilder)builder)::add);
        return ((FixedTypeMapBuilder)builder).freeze();
    }

    public static <V> TypeMapBuilder<V> fixedTypeMapBuilder() {
        return new FixedTypeMapBuilder();
    }

    public static <V> TypeMap<V> nativeTypeMap(Map<Class<?>, V> m) {
        return TypeMap.nativeTypeMap(m, true);
    }

    public static <V> TypeMap<V> nativeTypeMap(Map<Class<?>, V> m, boolean autobox) {
        Check.notNull(m, (String)SOURCE_MAP);
        TypeMapBuilder builder = new NativeTypeMapBuilder().autobox(autobox);
        m.forEach(((NativeTypeMapBuilder)builder)::add);
        return ((NativeTypeMapBuilder)builder).freeze();
    }

    public static <V> TypeMapBuilder<V> nativeTypeMapBuilder() {
        return new NativeTypeMapBuilder();
    }

    public static <V> TypeMap<V> greedyTypeMap(Map<Class<?>, V> m) {
        return TypeMap.greedyTypeMap(m, true);
    }

    public static <V> TypeMap<V> greedyTypeMap(Map<Class<?>, V> m, boolean autobox) {
        Check.notNull(m, (String)SOURCE_MAP);
        TypeMapBuilder builder = new GreedyTypeMapBuilder().autobox(autobox);
        m.forEach(((GreedyTypeMapBuilder)builder)::add);
        return ((GreedyTypeMapBuilder)builder).freeze();
    }

    public static <V> TypeMapBuilder<V> greedyTypeMapBuilder() {
        return new GreedyTypeMapBuilder();
    }

    public static <V> TypeMap<V> treeTypeMap(Map<Class<?>, V> m) {
        return TypeMap.treeTypeMap(m, true);
    }

    public static <V> TypeMap<V> treeTypeMap(Map<Class<?>, V> m, boolean autobox) {
        Check.notNull(m, (String)SOURCE_MAP);
        TypeMapBuilder builder = new TreeTypeMapBuilder().autobox(autobox);
        m.forEach(((TreeTypeMapBuilder)builder)::add);
        return ((TreeTypeMapBuilder)builder).freeze();
    }

    public static <V> TypeMapBuilder<V> treeTypeMapBuilder() {
        return new TreeTypeMapBuilder();
    }

    @Override
    default public V getOrDefault(Object key, V defaultValue) {
        throw new UnsupportedOperationException();
    }
}

