/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.klojang.collections.NonExpandingTypeMap;

final class TypeTreeMap<V>
extends NonExpandingTypeMap<V> {
    private final TreeMap<Class<?>, V> backend;

    TypeTreeMap(TreeMap<Class<?>, V> src, boolean autobox) {
        super(autobox);
        this.backend = src;
    }

    @Override
    Map<Class<?>, V> backend() {
        return this.backend;
    }

    @Override
    public Set<Class<?>> keySet() {
        return Set.copyOf(this.backend.keySet());
    }

    @Override
    public Collection<V> values() {
        return Set.copyOf(this.backend.values());
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return this.backend.entrySet().stream().map(this.toImmutableEntry()).collect(Collectors.toUnmodifiableSet());
    }

    private UnaryOperator<Map.Entry<Class<?>, V>> toImmutableEntry() {
        return e -> new AbstractMap.SimpleImmutableEntry((Class)e.getKey(), e.getValue());
    }
}

