/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.collections.AbstractLinkedList;
import org.klojang.collections.WiredIterator;
import org.klojang.util.MathMethods;

public final class WiredList<E>
extends AbstractLinkedList<E> {
    public static <E> WiredList<E> of() {
        return new WiredList<E>();
    }

    public static <E> WiredList<E> of(E e) {
        return new WiredList<E>().append(e);
    }

    public static <E> WiredList<E> of(E e0, E e1) {
        return new WiredList<E>().append(e0).append(e1);
    }

    @SafeVarargs
    public static <E> WiredList<E> of(E e0, E e1, E e2, E ... moreElems) {
        AbstractLinkedList.Node<E> head;
        Check.notNull(moreElems, (String)"array");
        WiredList<E> wl = new WiredList<E>();
        AbstractLinkedList.Node<E> tail = head = new AbstractLinkedList.Node<E>(e0);
        tail = new AbstractLinkedList.Node<E>(tail, e1);
        tail = new AbstractLinkedList.Node<E>(tail, e2);
        for (E e : moreElems) {
            tail = new AbstractLinkedList.Node<E>(tail, e);
        }
        wl.head = head;
        wl.tail = tail;
        wl.sz = moreElems.length + 3;
        return wl;
    }

    public static <E> WiredList<E> ofElements(E[] elements) {
        Check.notNull(elements, (String)"array");
        WiredList<E> wl = new WiredList<E>();
        if (elements.length != 0) {
            AbstractLinkedList.Node<E> head;
            AbstractLinkedList.Node<E> tail = head = new AbstractLinkedList.Node<E>(elements[0]);
            for (int i = 1; i < elements.length; ++i) {
                tail = new AbstractLinkedList.Node<E>(tail, elements[i]);
            }
            wl.head = head;
            wl.tail = tail;
            wl.sz = elements.length;
        }
        return wl;
    }

    public static <E> WiredList<E> join(List<WiredList<E>> lists) {
        WiredList<E> wl = new WiredList<E>();
        ((List)Check.notNull(lists).ok()).forEach(wl::attach);
        return wl;
    }

    public WiredList() {
    }

    public WiredList(Collection<? extends E> c) {
        this.addAll(0, (Collection)c);
    }

    private WiredList(AbstractLinkedList.Chain chain) {
        this.makeHead(chain.head);
        this.makeTail(chain.tail);
        this.sz = chain.length;
    }

    public WiredList<E> set(int index, E e0, E e1, E ... moreElems) {
        this.set0(index, e0, e1, moreElems);
        return this;
    }

    public E setIf(int index, Predicate<? super E> condition, E value) {
        return this.setIf0(index, condition, value);
    }

    @Override
    public E remove(int index) {
        return this.destroy(this.node(index));
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            AbstractLinkedList.Node x = this.head;
            while (x != null) {
                if (x.val == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            AbstractLinkedList.Node x = this.head;
            while (x != null) {
                if (o.equals(x.val)) {
                    this.destroy(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Check.notNull(filter, (String)"filter");
        int size = this.sz;
        AbstractLinkedList.Node x = this.head;
        while (x != null) {
            if (filter.test(x.val)) {
                AbstractLinkedList.Node next = x.next;
                this.destroy(x);
                x = next;
                continue;
            }
            x = x.next;
        }
        return size != this.sz;
    }

    public E first() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return (E)this.head.val;
    }

    public E last() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return (E)this.tail.val;
    }

    public WiredList<E> prepend(E value) {
        this.prepend0(value);
        return this;
    }

    public WiredList<E> prependAll(Collection<? extends E> values) {
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(0, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    public WiredList<E> append(E value) {
        this.add((Object)value);
        return this;
    }

    public WiredList<E> appendAll(Collection<? extends E> values) {
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(this.sz, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    public WiredList<E> insert(int index, E value) {
        this.checkInclusive(index);
        this.insert(index, new AbstractLinkedList.Node<E>(value));
        return this;
    }

    public WiredList<E> insertAll(int index, Collection<? extends E> values) {
        this.checkInclusive(index);
        Check.notNull(values, (String)"collection");
        if (!values.isEmpty()) {
            this.insert(index, AbstractLinkedList.Chain.of(values));
        }
        return this;
    }

    @Override
    public E removeFirst() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return this.destroy(this.head);
    }

    @Override
    public E removeLast() {
        Check.that((int)this.sz).isNot((IntPredicate)CommonChecks.zero(), CommonExceptions.noSuchElement());
        return this.destroy(this.tail);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (this.sz != 0) {
            AbstractLinkedList.Node x = this.head;
            while (true) {
                x.val = operator.apply(x.val);
                if (x == this.tail) break;
                x = x.next;
            }
        }
    }

    public WiredList<E> replaceAll(int fromIndex, int toIndex, Collection<? extends E> values) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull(values, (String)"collection");
        if (len == 0) {
            if (!values.isEmpty()) {
                this.insert(fromIndex, AbstractLinkedList.Chain.of(values));
            }
        } else if (len < values.size()) {
            this.cut(fromIndex, toIndex).clear();
            if (!values.isEmpty()) {
                this.insert(fromIndex, AbstractLinkedList.Chain.of(values));
            }
        } else {
            AbstractLinkedList.Node<Object> node = this.nodeAt(fromIndex);
            for (E e : values) {
                node.val = e;
                node = node.next;
            }
            if (len > values.size()) {
                AbstractLinkedList.Node end = this.nodeAfter(node, fromIndex + values.size(), toIndex - 1);
                AbstractLinkedList.Chain chain = new AbstractLinkedList.Chain(node, end, len - values.size());
                new WiredList<E>(this.unlink(chain)).clear();
            }
        }
        return this;
    }

    public WiredList<E> replace(int fromIndex, int toIndex, WiredList<? extends E> other) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.notNull(other, (String)this.className).isNot(CommonChecks.sameAs(), (Object)this, WiredList.autoEmbedNotAllowed());
        if (len == other.sz) {
            AbstractLinkedList.Node<Object> x = this.nodeAt(fromIndex);
            AbstractLinkedList.Node y = other.head;
            for (int i = 0; i < len; ++i) {
                x.val = y.val;
                x = x.next;
                y = y.next;
            }
            other.head = null;
            other.tail = null;
            other.sz = 0;
        } else {
            if (len != 0) {
                this.cut(fromIndex, toIndex).clear();
            }
            if (!other.isEmpty()) {
                this.insert(fromIndex, other.unlink(0, other.sz));
            }
        }
        return this;
    }

    public WiredList<E> copy() {
        return this.sz > 0 ? new WiredList<E>(AbstractLinkedList.Chain.copyOf(this.head, this.sz)) : WiredList.of();
    }

    public WiredList<E> copy(int fromIndex, int toIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        return len > 0 ? new WiredList<E>(AbstractLinkedList.Chain.copyOf(this.nodeAt(fromIndex), len)) : WiredList.of();
    }

    public WiredList<E> shrink(int fromIndex, int toIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        if (len == 0) {
            this.clear();
        } else if (len != this.sz) {
            int i;
            AbstractLinkedList.Node curr = this.head;
            for (i = 0; i < fromIndex; ++i) {
                AbstractLinkedList.Node next = curr.next;
                curr.prev = null;
                curr.next = null;
                curr.val = null;
                curr = next;
            }
            this.head = curr;
            curr = this.tail;
            for (i = toIndex; i < this.sz; ++i) {
                AbstractLinkedList.Node prev = curr.prev;
                curr.prev = null;
                curr.next = null;
                curr.val = null;
                curr = prev;
            }
            this.tail = curr;
            this.sz -= len;
        }
        return this;
    }

    public WiredList<E> cut(int fromIndex, int toIndex) {
        if (Check.fromTo((List)this, (int)fromIndex, (int)toIndex) > 0) {
            return new WiredList<E>(this.unlink(fromIndex, toIndex));
        }
        return WiredList.of();
    }

    public WiredList<? super E> paste(WiredList<? super E> into, int index) {
        return into.embed(index, this);
    }

    public WiredList<E> embed(int index, WiredList<? extends E> other) {
        this.checkInclusive(index);
        Check.notNull(other, (String)this.className).isNot(CommonChecks.sameAs(), (Object)this, WiredList.autoEmbedNotAllowed());
        if (!other.isEmpty()) {
            this.insert(index, new AbstractLinkedList.Chain(other.head, other.tail, other.sz));
            other.head = null;
            other.tail = null;
            other.sz = 0;
        }
        return this;
    }

    public WiredList<E> swap(int from1, int to1, int from2, int to2) {
        this.swap0(from1, to1, from2, to2);
        return this;
    }

    public WiredList<E> exchange(int myFromIndex, int myToIndex, WiredList<E> other, int itsFromIndex, int itsToIndex) {
        int len0 = Check.fromTo((List)this, (int)myFromIndex, (int)myToIndex);
        int len1 = Check.fromTo(other, (int)itsFromIndex, (int)itsToIndex);
        Check.that(other).isNot(CommonChecks.sameAs(), (Object)this, WiredList.autoEmbedNotAllowed());
        if (len0 == 0) {
            if (len1 != 0) {
                this.insert(myFromIndex, other.unlink(itsFromIndex, itsToIndex));
            }
            return this;
        }
        if (len1 == 0) {
            other.insert(itsFromIndex, this.unlink(myFromIndex, myToIndex));
            return this;
        }
        AbstractLinkedList.Node seg0L = this.nodeAt(myFromIndex);
        AbstractLinkedList.Node seg0R = this.nodeAfter(seg0L, myFromIndex, myToIndex - 1);
        AbstractLinkedList.Node seg1L = other.nodeAt(itsFromIndex);
        AbstractLinkedList.Node seg1R = other.nodeAfter(seg1L, itsFromIndex, itsToIndex - 1);
        AbstractLinkedList.Node att0L = seg0L.prev;
        AbstractLinkedList.Node att0R = seg0R.next;
        AbstractLinkedList.Node att1L = seg1L.prev;
        AbstractLinkedList.Node att1R = seg1R.next;
        if (att0L == null) {
            this.makeHead(seg1L);
        } else {
            WiredList.join(att0L, seg1L);
        }
        if (att0R == null) {
            this.makeTail(seg1R);
        } else {
            WiredList.join(seg1R, att0R);
        }
        if (att1L == null) {
            other.makeHead(seg0L);
        } else {
            WiredList.join(att1L, seg0L);
        }
        if (att1R == null) {
            other.makeTail(seg0R);
        } else {
            WiredList.join(seg0R, att1R);
        }
        this.sz = this.sz - len0 + len1;
        other.sz = other.sz - len1 + len0;
        return this;
    }

    public WiredList<E> embed(int myIndex, WiredList<? extends E> other, int itsFromIndex, int itsToIndex) {
        this.checkInclusive(myIndex);
        int len = Check.fromTo(other, (int)itsFromIndex, (int)itsToIndex);
        Check.that(other).isNot(CommonChecks.sameAs(), (Object)this, WiredList.autoEmbedNotAllowed());
        if (len > 0) {
            this.insert(myIndex, other.unlink(itsFromIndex, itsToIndex));
        }
        return this;
    }

    public WiredList<E> attach(WiredList<? extends E> other) {
        Check.notNull(other).isNot(CommonChecks.sameAs(), (Object)this, WiredList.autoEmbedNotAllowed());
        if (other.sz != 0) {
            this.attach0(other);
        }
        return this;
    }

    private void attach0(WiredList other) {
        if (this.sz == 0) {
            this.head = other.head;
        } else {
            WiredList.join(this.tail, other.head);
        }
        this.tail = other.tail;
        this.sz += other.sz;
        other.head = null;
        other.tail = null;
        other.sz = 0;
    }

    public WiredList<E> defragment(List<Predicate<? super E>> criteria) {
        return this.defragment(true, criteria);
    }

    public WiredList<E> defragment(boolean keepRemainder, List<Predicate<? super E>> criteria) {
        Check.that(criteria).is((Predicate)CommonChecks.deepNotEmpty());
        WiredList<WiredList<E>> groups = this.createGroups(criteria);
        AbstractLinkedList.Chain rest = new AbstractLinkedList.Chain(this.head, this.tail, this.sz);
        this.sz = 0;
        for (WiredList wiredList : groups) {
            if (wiredList.isEmpty()) continue;
            this.attach0(wiredList);
        }
        if (keepRemainder && rest.length != 0) {
            this.insert(this.sz, rest);
        }
        return this;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 group(Predicate<? super E> criterion) {
        return this.group(Collections.singletonList(criterion));
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 group(List<Predicate<? super E>> criteria) {
        Check.that(criteria).is((Predicate)CommonChecks.deepNotEmpty());
        WiredList<WiredList<? super E>> groups = this.createGroups(criteria);
        WiredList<WiredList<E>> result = new WiredList<WiredList<E>>(groups);
        result.add((Object)this);
        return (L1)result;
    }

    private WiredList<WiredList<E>> createGroups(List<Predicate<? super E>> criteria) {
        WiredList groups = new WiredList();
        criteria.forEach(c -> groups.append(new WiredList()));
        AbstractLinkedList.Node node = this.head;
        while (node != null) {
            AbstractLinkedList.Node next = node.next;
            for (int i = 0; i < criteria.size(); ++i) {
                if (!criteria.get(i).test(node.val)) continue;
                this.unlink(node);
                WiredList wl = (WiredList)groups.get(i);
                wl.insert(wl.size(), node);
                break;
            }
            node = next;
        }
        return groups;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 partition(int size) {
        Check.that((int)size).is(CommonChecks.gt(), 0);
        WiredList<WiredList> partitions = new WiredList<WiredList>();
        while (this.sz > size) {
            AbstractLinkedList.Chain chain = new AbstractLinkedList.Chain(this.head, this.nodeAt(size - 1), size);
            partitions.append(new WiredList<E>(this.unlink(chain)));
        }
        partitions.append(this);
        return (L1)partitions;
    }

    public <L0 extends List<E>, L1 extends List<L0>> L1 split(int numPartitions) {
        Check.that((int)numPartitions).is(CommonChecks.gt(), 0);
        return this.partition(MathMethods.divUp((int)this.sz, (int)numPartitions));
    }

    public WiredList<E> lchop(Predicate<? super E> criterion) {
        Check.notNull(criterion);
        if (this.sz == 0) {
            return this;
        }
        AbstractLinkedList.Node first = this.head;
        AbstractLinkedList.Node<Object> last = this.justBeforeHead();
        int len = 0;
        while (criterion.test(last.next.val) && ++len != this.sz) {
            last = last.next;
        }
        if (len == this.sz) {
            return this;
        }
        return new WiredList<E>(this.unlink(new AbstractLinkedList.Chain(first, last, len)));
    }

    public WiredList<E> rchop(Predicate<? super E> criterion) {
        Check.notNull(criterion);
        if (this.sz == 0) {
            return this;
        }
        AbstractLinkedList.Node last = this.tail;
        AbstractLinkedList.Node<Object> first = this.justAfterTail();
        int len = 0;
        while (criterion.test(first.prev.val) && ++len != this.sz) {
            first = first.prev;
        }
        if (len == this.sz) {
            return this;
        }
        return new WiredList<E>(this.unlink(new AbstractLinkedList.Chain(first, last, len)));
    }

    public WiredList<E> reverse() {
        this.reverse0();
        return this;
    }

    public WiredList<E> move(int fromIndex, int toIndex, int newFromIndex) {
        int len = Check.fromTo((List)this, (int)fromIndex, (int)toIndex);
        Check.that((int)newFromIndex, (String)"target index").is(CommonChecks.indexInclusiveOf(), (Object)this);
        if (len != 0) {
            if (newFromIndex > fromIndex) {
                this.moveRight(fromIndex, toIndex, newFromIndex);
            } else if (newFromIndex < fromIndex) {
                this.moveLeft(fromIndex, toIndex, newFromIndex);
            }
        }
        return this;
    }

    @Override
    public void clear() {
        if (this.sz != 0) {
            AbstractLinkedList.Node curr = this.head;
            while (true) {
                curr.val = null;
                if (curr == this.tail) break;
                AbstractLinkedList.Node next = curr.next;
                curr.next = null;
                curr.prev = null;
                curr = next;
            }
            curr.prev = null;
            this.tail = null;
            this.head = null;
            this.sz = 0;
        }
    }

    public Iterator<E> reverseIterator() {
        return super.reverseIterator0();
    }

    public WiredIterator<E> wiredIterator() {
        return new WFwdWiredIterator();
    }

    public WiredIterator<E> wiredIterator(boolean reverse) {
        return reverse ? new WRevWiredIterator() : new WFwdWiredIterator();
    }

    public Object[] regionToArray(int fromIndex, int toIndex) {
        return this.regionToArray0(fromIndex, toIndex);
    }

    public void regionToArray(int fromIndex, int toIndex, Object[] target, int offset) {
        this.regionToArray0(fromIndex, toIndex, target, offset);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private E destroy(AbstractLinkedList.Node<E> node) {
        Object val = node.val;
        this.unlink(node);
        node.val = null;
        node.next = null;
        node.prev = null;
        return (E)val;
    }

    final class WFwdWiredIterator
    extends AbstractLinkedList.ForwardWiredIterator {
        private WFwdWiredIterator() {
            super(WiredList.this);
        }

        private WFwdWiredIterator(AbstractLinkedList.Node<E> curr) {
            super(WiredList.this, curr);
        }

        @Override
        public void remove() {
            Check.that((Object)this.curr).isNot(CommonChecks.sameAs(), (Object)this.beforeHead, AbstractLinkedList.callNextFirst());
            Check.that((int)WiredList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            if (this.curr == WiredList.this.head) {
                WiredList.this.destroy(this.curr);
                this.curr = this.beforeHead = WiredList.this.justBeforeHead();
            } else {
                this.curr = this.curr.prev;
                Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).then(prev -> WiredList.this.destroy(prev.next));
            }
        }

        @Override
        WiredIterator<E> getReverseWiredIterator(AbstractLinkedList.Node<E> curr) {
            return new WRevWiredIterator(curr);
        }
    }

    final class WRevWiredIterator
    extends AbstractLinkedList.ReverseWiredIterator {
        private WRevWiredIterator() {
            super(WiredList.this);
        }

        private WRevWiredIterator(AbstractLinkedList.Node<E> curr) {
            super(WiredList.this, curr);
        }

        @Override
        public void remove() {
            Check.that((Object)this.curr).isNot(CommonChecks.sameAs(), (Object)this.afterTail, AbstractLinkedList.callNextFirst());
            Check.that((int)WiredList.this.sz).isNot((IntPredicate)CommonChecks.zero(), AbstractLinkedList.emptyList());
            if (this.curr == WiredList.this.tail) {
                WiredList.this.destroy(this.curr);
                this.curr = this.afterTail = WiredList.this.justAfterTail();
            } else {
                this.curr = this.curr.next;
                Check.that(this.curr).is((Predicate)CommonChecks.notNull(), AbstractLinkedList.concurrentModification()).then(next -> WiredList.this.destroy(next.prev));
            }
        }

        @Override
        WiredIterator<E> getForwardWiredIterator(AbstractLinkedList.Node<E> curr) {
            return new WFwdWiredIterator(curr);
        }
    }
}

