/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Collection;
import java.util.Iterator;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonProperties;
import org.klojang.collections.ImmutableSet;
import org.klojang.collections.TypeMap;
import org.klojang.collections.TypeSet;

abstract non-sealed class AbstractTypeSet
extends ImmutableSet<Class<?>>
implements TypeSet {
    private final TypeMap<Object> map = this.createBackend();

    AbstractTypeSet() {
    }

    abstract TypeMap<Object> createBackend();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return (Boolean)Check.notNull((Object)o).has(CommonProperties.type(), CommonChecks.sameAs(), Class.class).ok(this.map::containsKey);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Check.notNull(a);
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Check.notNull(c);
        return c.stream().filter(this.map::containsKey).count() == (long)c.size();
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.keySet().equals(obj);
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

