/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.ImmutableSet;
import org.klojang.util.ArrayMethods;
import org.klojang.util.InvokeMethods;

final class ArraySet<E>
extends ImmutableSet<E> {
    private static final ArraySet EMPTY = new ArraySet(ArrayMethods.EMPTY_OBJECT_ARRAY);
    private final Object[] elems;
    private int hash;
    private String str;

    private static <E> ArraySet<E> empty() {
        return EMPTY;
    }

    static <E> ArraySet<E> of(E[] values) {
        return values.length != 0 ? new ArraySet<E>(values) : ArraySet.empty();
    }

    static <E> ArraySet<E> copyOf(Collection<E> values) {
        return values.size() != 0 ? new ArraySet<E>(values.toArray()) : ArraySet.empty();
    }

    private ArraySet(Object[] elems) {
        this.elems = elems;
    }

    @Override
    public int size() {
        return this.elems.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return ArrayMethods.isElementOf((Object)o, (Object[])this.elems);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return new HashSet(this).containsAll(c);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Check.notNull(a);
        int sz = this.elems.length;
        if (a.length < sz) {
            a = (Object[])InvokeMethods.newArray(a.getClass(), (int)sz);
        }
        int i = 0;
        T[] result = a;
        for (E val : this) {
            result[i++] = val;
        }
        if (a.length > sz) {
            a[sz] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArraySet.this.elems.length;
            }

            @Override
            public E next() {
                Check.that((int)this.i).is(CommonChecks.lt(), ArraySet.this.size(), NoSuchElementException::new);
                return ArraySet.this.elems[this.i++];
            }
        };
    }

    @Override
    public Object[] toArray() {
        if (this == EMPTY) {
            return ArrayMethods.EMPTY_OBJECT_ARRAY;
        }
        Object[] objs = new Object[this.elems.length];
        System.arraycopy(this.elems, 0, objs, 0, this.elems.length);
        return objs;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.elems);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArraySet) {
            ArraySet other = (ArraySet)o;
            int len = other.elems.length;
            if (this.elems.length == len) {
                for (int i = 0; i < len; ++i) {
                    if (this.elems[i].equals(other.elems[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o instanceof Set) {
            Set s = (Set)o;
            Iterator itr = s.iterator();
            for (Object e : this.elems) {
                if (itr.hasNext() && e.equals(itr.next())) continue;
                return false;
            }
            return !itr.hasNext();
        }
        return false;
    }

    public String toString() {
        if (this.str == null) {
            this.str = "[" + ArrayMethods.implode((Object[])this.elems) + "]";
        }
        return this.str;
    }
}

