/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.ImmutableMap;
import org.klojang.collections.TypeMap;
import org.klojang.util.ArrayType;
import org.klojang.util.ClassMethods;
import org.klojang.util.ObjectMethods;
import org.klojang.util.Tuple2;

final class GreedyTypeMap<V>
extends ImmutableMap<Class<?>, V>
implements TypeMap<V> {
    private final HashMap<Class<?>, V> backend;
    private final boolean autobox;
    private static final Object NULL = new Object();
    private Tuple2<Class<?>, V> defVal;

    GreedyTypeMap(HashMap<Class<?>, V> src, boolean autobox) {
        this.backend = src;
        this.autobox = autobox;
    }

    @Override
    public V get(Object key) {
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        Tuple2<Class<?>, V> entry = this.find(type);
        if (entry.second() == NULL) {
            return null;
        }
        if (type != entry.first()) {
            this.backend.put(type, entry.second());
        }
        return (V)entry.second();
    }

    @Override
    public boolean containsKey(Object key) {
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        Tuple2<Class<?>, V> entry = this.find(type);
        if (entry.second() == NULL) {
            return false;
        }
        if (type != entry.first()) {
            this.backend.put(type, entry.second());
        }
        return true;
    }

    private Tuple2<Class<?>, V> find(Class<?> type) {
        V val = this.backend.get(type);
        if (val != null) {
            return Tuple2.of(type, val);
        }
        Tuple2<Class<?>, V> result = null;
        if (type.isArray()) {
            result = this.findArrayType(type);
        } else if (type.isPrimitive()) {
            if (this.autobox) {
                result = this.find(ClassMethods.box(type));
            }
        } else if (type.isInterface()) {
            result = this.findInterface(type);
        } else {
            result = this.findSuperClass(type);
            if (result == null) {
                result = this.findInterface(type);
            }
        }
        if (result == null) {
            return this.getDefaultValue();
        }
        return result;
    }

    private Tuple2<Class<?>, V> findSuperClass(Class<?> type) {
        Class c;
        List supertypes = ClassMethods.getAncestors(type);
        Iterator iterator = supertypes.iterator();
        while (iterator.hasNext() && (c = (Class)iterator.next()) != Object.class) {
            V val = this.backend.get(c);
            if (val == null) continue;
            return Tuple2.of((Object)c, val);
        }
        return null;
    }

    private Tuple2<Class<?>, V> findInterface(Class<?> type) {
        Set supertypes = ClassMethods.getAllInterfaces(type);
        for (Class c : supertypes) {
            V val = this.backend.get(c);
            if (val == null) continue;
            return Tuple2.of((Object)c, val);
        }
        return null;
    }

    private Tuple2<Class<?>, V> findArrayType(Class<?> type) {
        ArrayType arrayType = ArrayType.forClass(type);
        if (arrayType.baseType().isPrimitive() && this.autobox) {
            return this.find(arrayType.box());
        }
        if (arrayType.baseType().isInterface()) {
            Tuple2<Class<?>, V> result = this.findInterfaceArray(arrayType);
            if (result != null) {
                return result;
            }
        } else {
            Tuple2<Class<?>, V> result = this.findSuperClassArray(arrayType);
            if (result != null) {
                return result;
            }
            result = this.findInterfaceArray(arrayType);
            if (result != null) {
                return result;
            }
        }
        return (Tuple2)ObjectMethods.ifNotNull(this.backend.get(Object[].class), v -> Tuple2.of(Object[].class, (Object)v));
    }

    private Tuple2<Class<?>, V> findSuperClassArray(ArrayType arrayType) {
        Class c;
        List supertypes = ClassMethods.getAncestors((Class)arrayType.baseType());
        Iterator iterator = supertypes.iterator();
        while (iterator.hasNext() && (c = (Class)iterator.next()) != Object.class) {
            Class arrayClass = arrayType.toClass(c);
            V val = this.backend.get(arrayClass);
            if (val == null) continue;
            return Tuple2.of((Object)arrayClass, val);
        }
        return null;
    }

    private Tuple2<Class<?>, V> findInterfaceArray(ArrayType arrayType) {
        Set supertypes = ClassMethods.getAllInterfaces((Class)arrayType.baseType());
        for (Class c : supertypes) {
            Class arrayClass = arrayType.toClass(c);
            V val = this.backend.get(arrayClass);
            if (val == null) continue;
            return Tuple2.of((Object)arrayClass, val);
        }
        return null;
    }

    private Tuple2<Class<?>, V> getDefaultValue() {
        if (this.defVal == null) {
            Object val = ObjectMethods.ifNull(this.backend.get(Object.class), (Object)NULL);
            this.defVal = new Tuple2(Object.class, val);
        }
        return this.defVal;
    }

    @Override
    public int size() {
        return this.backend.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backend.containsValue(value);
    }

    @Override
    public int hashCode() {
        return this.backend.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.backend.equals(obj);
    }

    public String toString() {
        return this.backend.toString();
    }

    @Override
    public Set<Class<?>> keySet() {
        return Set.copyOf(this.backend.keySet());
    }

    @Override
    public Collection<V> values() {
        return Set.copyOf(this.backend.values());
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return this.immutableEntrySet();
    }

    private Set<Map.Entry<Class<?>, V>> immutableEntrySet() {
        return this.backend.entrySet().stream().map(this.makeImmutable()).collect(Collectors.toUnmodifiableSet());
    }

    private UnaryOperator<Map.Entry<Class<?>, V>> makeImmutable() {
        return e -> new AbstractMap.SimpleImmutableEntry((Class)e.getKey(), e.getValue());
    }
}

