/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.FixedTypeMapBuilder;
import org.klojang.collections.GreedyTypeMap;
import org.klojang.collections.TypeMapBuilder;

final class GreedyTypeMapBuilder<V>
implements TypeMapBuilder<V> {
    private final HashMap<Class<?>, V> tmp = new HashMap();
    private boolean autobox = true;

    GreedyTypeMapBuilder() {
    }

    @Override
    public GreedyTypeMapBuilder<V> autobox(boolean autobox) {
        this.autobox = autobox;
        return this;
    }

    @Override
    public GreedyTypeMapBuilder<V> add(Class<?> type, V value) {
        Check.notNull(type, (String)"type").isNot(CommonChecks.keyIn(), this.tmp, FixedTypeMapBuilder.duplicateKey(type));
        Check.notNull(value, (String)"value");
        this.tmp.put(type, value);
        return this;
    }

    @Override
    public GreedyTypeMapBuilder<V> addMultiple(V value, Class<?> ... types) {
        ((Stream)Check.notNull(types, (String)"types").ok(Arrays::stream)).forEach(t -> this.add((Class)t, (Object)value));
        return this;
    }

    @Override
    public GreedyTypeMap<V> freeze() {
        return new GreedyTypeMap<V>(this.tmp, this.autobox);
    }
}

