/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.aux.DuplicateValueException;
import org.klojang.collections.NativeTypeMap;
import org.klojang.collections.TypeMapBuilder;
import org.klojang.collections.TypeNode;
import org.klojang.collections.WiredIterator;
import org.klojang.collections.WiredList;
import org.klojang.util.ClassMethods;

final class NativeTypeMapBuilder<V>
implements TypeMapBuilder<V> {
    private final Set<Class<?>> all = new HashSet();
    private final List<WritableTypeNode> classes = new ArrayList<WritableTypeNode>();
    private final List<WritableTypeNode> interfaces = new ArrayList<WritableTypeNode>();
    private final WritableTypeNode root = new WritableTypeNode(Object.class, null);
    private boolean autobox = true;

    NativeTypeMapBuilder() {
    }

    @Override
    public NativeTypeMapBuilder<V> autobox(boolean autobox) {
        this.autobox = autobox;
        return this;
    }

    @Override
    public NativeTypeMapBuilder<V> add(Class<?> type, V value) {
        Check.notNull(type, (String)"type").isNot(CommonChecks.in(), this.all, () -> new DuplicateValueException(DuplicateValueException.Usage.KEY, (Object)type));
        Check.notNull(value, (String)"value");
        if (type == Object.class) {
            this.root.value = value;
        } else if (type.isInterface()) {
            this.interfaces.add(new WritableTypeNode(type, value));
        } else {
            this.classes.add(new WritableTypeNode(type, value));
        }
        this.all.add(type);
        return this;
    }

    @Override
    public NativeTypeMapBuilder<V> addMultiple(V value, Class<?> ... types) {
        Check.notNull(types, (String)"types");
        Arrays.stream(types).forEach(t -> this.add((Class)t, (Object)value));
        return this;
    }

    @Override
    public NativeTypeMap<V> freeze() {
        for (WritableTypeNode node : this.classes) {
            this.root.addClass(node);
        }
        for (WritableTypeNode node : this.interfaces) {
            this.root.addInterface(node);
        }
        return new NativeTypeMap(this.root.toTypeNode(), this.all.size(), this.autobox);
    }

    private static class WritableTypeNode {
        private final WiredList<WritableTypeNode> subclasses = new WiredList();
        private final WiredList<WritableTypeNode> extensions = new WiredList();
        private final Class<?> type;
        private Object value;

        WritableTypeNode(Class<?> type, Object val) {
            this.type = type;
            this.value = val;
        }

        TypeNode toTypeNode() {
            TypeNode[] extensions;
            TypeNode[] subclasses = (TypeNode[])this.subclasses.stream().map(WritableTypeNode::toTypeNode).toArray(TypeNode[]::new);
            if (subclasses.length == 0) {
                subclasses = TypeNode.NO_SUBTYPES;
            }
            if ((extensions = (TypeNode[])this.extensions.stream().map(WritableTypeNode::toTypeNode).toArray(TypeNode[]::new)).length == 0) {
                extensions = TypeNode.NO_SUBTYPES;
            }
            return new TypeNode(this.type, this.value, subclasses, extensions);
        }

        void addClass(WritableTypeNode node) {
            WritableTypeNode child;
            WiredIterator<WritableTypeNode> itr = this.subclasses.wiredIterator();
            while (itr.hasNext()) {
                child = (WritableTypeNode)itr.next();
                if (ClassMethods.isSupertype(node.type, child.type)) {
                    itr.remove();
                    node.addClass(child);
                    continue;
                }
                if (!ClassMethods.isSubtype(node.type, child.type)) continue;
                child.addClass(node);
                return;
            }
            itr = this.extensions.wiredIterator();
            while (itr.hasNext()) {
                child = (WritableTypeNode)itr.next();
                if (!ClassMethods.isSubtype(node.type, child.type)) continue;
                child.addClass(node);
                return;
            }
            this.subclasses.add((Object)node);
        }

        void addInterface(WritableTypeNode node) {
            WritableTypeNode child;
            WiredIterator<WritableTypeNode> itr = this.subclasses.wiredIterator();
            while (itr.hasNext()) {
                child = (WritableTypeNode)itr.next();
                if (!ClassMethods.isSupertype(node.type, child.type)) continue;
                itr.remove();
                node.addClass(child);
            }
            itr = this.extensions.wiredIterator();
            while (itr.hasNext()) {
                child = (WritableTypeNode)itr.next();
                if (ClassMethods.isSupertype(node.type, child.type)) {
                    itr.remove();
                    node.addInterface(child);
                    continue;
                }
                if (!ClassMethods.isSubtype(node.type, child.type)) continue;
                child.addInterface(node);
                return;
            }
            this.extensions.add((Object)node);
        }
    }
}

