/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.collections.FixedTypeMap;
import org.klojang.collections.ImmutableMap;
import org.klojang.collections.TypeMap;
import org.klojang.collections.TypeTreeMap;
import org.klojang.util.ArrayType;
import org.klojang.util.ClassMethods;

abstract sealed class NonExpandingTypeMap<V>
extends ImmutableMap<Class<?>, V>
implements TypeMap<V>
permits TypeTreeMap, FixedTypeMap {
    private final boolean autobox;
    private V defVal;

    NonExpandingTypeMap(boolean autobox) {
        this.autobox = autobox;
    }

    abstract Map<Class<?>, V> backend();

    @Override
    public V get(Object key) {
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        return this.find(type);
    }

    @Override
    public boolean containsKey(Object key) {
        Class type = (Class)Check.notNull((Object)key).is(CommonChecks.instanceOf(), Class.class).ok(Class.class::cast);
        return this.find(type) != null;
    }

    private V find(Class<?> type) {
        V val = this.backend().get(type);
        if (val != null) {
            return val;
        }
        if (type.isArray()) {
            val = this.findArrayType(type);
        } else if (type.isPrimitive()) {
            if (this.autobox) {
                val = this.find(ClassMethods.box(type));
            }
        } else if (type.isInterface()) {
            val = this.findInterface(type);
        } else {
            val = this.findSuperClass(type);
            if (val == null) {
                val = this.findInterface(type);
            }
        }
        if (val == null) {
            return this.getDefaultValue();
        }
        return val;
    }

    private V findSuperClass(Class<?> type) {
        Class c;
        List supertypes = ClassMethods.getAncestors(type);
        Iterator iterator = supertypes.iterator();
        while (iterator.hasNext() && (c = (Class)iterator.next()) != Object.class) {
            V val = this.backend().get(c);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private V findInterface(Class<?> type) {
        Set supertypes = ClassMethods.getAllInterfaces(type);
        for (Class c : supertypes) {
            V val = this.backend().get(c);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private V findArrayType(Class<?> type) {
        ArrayType arrayType = ArrayType.forClass(type);
        if (arrayType.baseType().isPrimitive() && this.autobox) {
            return this.find(arrayType.box());
        }
        if (arrayType.baseType().isInterface()) {
            V result = this.findInterfaceArray(arrayType);
            if (result != null) {
                return result;
            }
        } else {
            V result = this.findSuperClassArray(arrayType);
            if (result != null) {
                return result;
            }
            result = this.findInterfaceArray(arrayType);
            if (result != null) {
                return result;
            }
        }
        return this.backend().get(Object[].class);
    }

    private V findSuperClassArray(ArrayType arrayType) {
        Class c;
        List supertypes = ClassMethods.getAncestors((Class)arrayType.baseType());
        Iterator iterator = supertypes.iterator();
        while (iterator.hasNext() && (c = (Class)iterator.next()) != Object.class) {
            V val = this.backend().get(arrayType.toClass(c));
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private V findInterfaceArray(ArrayType arrayType) {
        Set supertypes = ClassMethods.getAllInterfaces((Class)arrayType.baseType());
        for (Class c : supertypes) {
            V val = this.backend().get(arrayType.toClass(c));
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private V getDefaultValue() {
        if (this.defVal == null) {
            this.defVal = this.backend().get(Object.class);
        }
        return this.defVal;
    }

    @Override
    public int size() {
        return this.backend().size();
    }

    @Override
    public boolean isEmpty() {
        return this.backend().isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backend().containsValue(value);
    }

    @Override
    public int hashCode() {
        return this.backend().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.backend().equals(obj);
    }

    public String toString() {
        return this.backend().toString();
    }
}

