/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.Comparator;
import org.klojang.util.ArrayMethods;
import org.klojang.util.ClassMethods;

final class PrettyTypeComparator
implements Comparator<Class<?>> {
    PrettyTypeComparator() {
    }

    @Override
    public int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1.isPrimitive()) {
            return -1;
        }
        if (c2.isPrimitive()) {
            return 1;
        }
        if (ClassMethods.isWrapper(c1)) {
            return -1;
        }
        if (ClassMethods.isWrapper(c2)) {
            return 1;
        }
        if (c1.isEnum()) {
            return -1;
        }
        if (c2.isEnum()) {
            return 1;
        }
        if (c1 == Object.class) {
            return 1;
        }
        if (c2 == Object.class) {
            return -1;
        }
        if (c1.isArray()) {
            if (c2.isArray()) {
                return this.compare(c1.getComponentType(), c2.getComponentType());
            }
            return 1;
        }
        if (c2.isArray()) {
            return -1;
        }
        if (c1.isInterface()) {
            if (c2.isInterface()) {
                if (ClassMethods.getAllInterfaces(c1).size() < ClassMethods.getAllInterfaces(c2).size()) {
                    return 1;
                }
                if (ClassMethods.getAllInterfaces(c1).size() > ClassMethods.getAllInterfaces(c2).size()) {
                    return -1;
                }
            }
            return 1;
        }
        if (c2.isInterface()) {
            return -1;
        }
        if (ClassMethods.countAncestors(c1) < ClassMethods.countAncestors(c2)) {
            return 1;
        }
        if (ClassMethods.countAncestors(c1) > ClassMethods.countAncestors(c2)) {
            return -1;
        }
        if (ClassMethods.getAllInterfaces(c1).size() < ClassMethods.getAllInterfaces(c2).size()) {
            return 1;
        }
        if (ClassMethods.getAllInterfaces(c1).size() > ClassMethods.getAllInterfaces(c2).size()) {
            return -1;
        }
        String[] s1 = (String[])ArrayMethods.reverse((Object[])c1.getName().split("\\."));
        String[] s2 = (String[])ArrayMethods.reverse((Object[])c2.getName().split("\\."));
        return Arrays.compare((Comparable[])s1, (Comparable[])s2);
    }
}

