/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.klojang.util.ClassMethods;

final class TypeNode {
    static final TypeNode[] NO_SUBTYPES = new TypeNode[0];
    final Class<?> type;
    final Object value;
    final TypeNode[] subclasses;
    final TypeNode[] extensions;

    TypeNode(Class<?> type, Object value, TypeNode[] subclasses, TypeNode[] extensions) {
        this.type = type;
        this.value = value;
        this.subclasses = subclasses;
        this.extensions = extensions;
    }

    <T> T value() {
        return (T)this.value;
    }

    <T> T get(Class<?> type) {
        return type.isInterface() ? this.findInterface(type) : this.findClass(type);
    }

    <T> T getPrimitive(Class<?> type) {
        return (T)TypeNode.findClass(type, this.subclasses);
    }

    void collectTypes(List<Class<?>> bucket) {
        for (TypeNode node : this.extensions) {
            bucket.add(node.type);
        }
        for (TypeNode node : this.subclasses) {
            bucket.add(node.type);
        }
        for (TypeNode node : this.extensions) {
            node.collectTypes(bucket);
        }
        for (TypeNode node : this.subclasses) {
            node.collectTypes(bucket);
        }
    }

    <E> void collectValues(List<E> bucket) {
        for (TypeNode node : this.extensions) {
            bucket.add(node.value());
            node.collectValues(bucket);
        }
        for (TypeNode node : this.subclasses) {
            bucket.add(node.value());
            node.collectValues(bucket);
        }
    }

    <E> void collectEntries(List<Map.Entry<Class<?>, E>> bucket) {
        for (TypeNode node : this.extensions) {
            bucket.add(new AbstractMap.SimpleImmutableEntry(node.type, node.value()));
            node.collectEntries(bucket);
        }
        for (TypeNode node : this.subclasses) {
            bucket.add(new AbstractMap.SimpleImmutableEntry(node.type, node.value()));
            node.collectEntries(bucket);
        }
    }

    private <T> T findClass(Class<?> type) {
        if (!ClassMethods.isSupertype(this.type, type)) {
            return null;
        }
        Object val = this.findAsSubclass(type);
        if (val == null && (val = this.findAsImpl(type)) == null) {
            val = this.value;
        }
        return (T)val;
    }

    private <T> T findInterface(Class<?> type) {
        if (!ClassMethods.isSupertype(this.type, type)) {
            return null;
        }
        Object val = this.findAsExtension(type);
        if (val == null) {
            val = this.value;
        }
        return (T)val;
    }

    private Object findAsSubclass(Class<?> type) {
        return TypeNode.findClass(type, this.subclasses);
    }

    private Object findAsImpl(Class<?> type) {
        return TypeNode.findClass(type, this.extensions);
    }

    private Object findAsExtension(Class<?> type) {
        for (TypeNode node : this.extensions) {
            Object val = node.findInterface(type);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private static Object findClass(Class<?> type, TypeNode[] nodes) {
        for (TypeNode node : nodes) {
            Object val = node.findClass(type);
            if (val == null) continue;
            return val;
        }
        return null;
    }
}

