/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.klojang.check.Check;
import org.klojang.collections.AbstractTypeSet;
import org.klojang.collections.ArraySet;
import org.klojang.collections.FixedTypeMapBuilder;
import org.klojang.collections.GreedyTypeMapBuilder;
import org.klojang.collections.NativeTypeMapBuilder;
import org.klojang.collections.PrettyTypeComparator;
import org.klojang.collections.TreeTypeMapBuilder;
import org.klojang.collections.TypeMap;

public sealed interface TypeSet
extends Set<Class<?>>
permits AbstractTypeSet {
    public static TypeSet fixedTypeSet(Collection<Class<?>> types) {
        return TypeSet.fixedTypeSet(true, types);
    }

    public static TypeSet fixedTypeSet(boolean autobox, Collection<Class<?>> types) {
        return TypeSet.fixedTypeSet(autobox, (Class[])types.toArray(Class[]::new));
    }

    public static TypeSet fixedTypeSet(Class<?> ... types) {
        return TypeSet.fixedTypeSet(true, types);
    }

    public static TypeSet fixedTypeSet(final boolean autobox, final Class<?> ... types) {
        Check.notNull(types);
        return new AbstractTypeSet(){

            @Override
            TypeMap<Object> createBackend() {
                return ((FixedTypeMapBuilder)((FixedTypeMapBuilder)new FixedTypeMapBuilder().autobox(autobox)).addMultiple(Boolean.TRUE, types)).freeze();
            }
        };
    }

    public static TypeSet nativeTypeSet(Collection<Class<?>> types) {
        return TypeSet.nativeTypeSet(true, types);
    }

    public static TypeSet nativeTypeSet(boolean autobox, Collection<Class<?>> types) {
        return TypeSet.nativeTypeSet(autobox, (Class[])types.toArray(Class[]::new));
    }

    public static TypeSet nativeTypeSet(Class<?> ... types) {
        return TypeSet.nativeTypeSet(true, types);
    }

    public static TypeSet nativeTypeSet(final boolean autobox, final Class<?> ... types) {
        Check.notNull(types);
        return new AbstractTypeSet(){

            @Override
            TypeMap<Object> createBackend() {
                return ((NativeTypeMapBuilder)((NativeTypeMapBuilder)new NativeTypeMapBuilder().autobox(autobox)).addMultiple(Boolean.TRUE, types)).freeze();
            }
        };
    }

    public static TypeSet greedyTypeSet(Collection<Class<?>> types) {
        return TypeSet.greedyTypeSet(true, types);
    }

    public static TypeSet greedyTypeSet(boolean autobox, Collection<Class<?>> types) {
        return TypeSet.greedyTypeSet(autobox, (Class[])types.toArray(Class[]::new));
    }

    public static TypeSet greedyTypeSet(Class<?> ... types) {
        return TypeSet.greedyTypeSet(true, types);
    }

    public static TypeSet greedyTypeSet(final boolean autobox, final Class<?> ... types) {
        Check.notNull(types);
        return new AbstractTypeSet(){

            @Override
            TypeMap<Object> createBackend() {
                return ((GreedyTypeMapBuilder)((GreedyTypeMapBuilder)new GreedyTypeMapBuilder().autobox(autobox)).addMultiple(Boolean.TRUE, types)).freeze();
            }
        };
    }

    public static TypeSet treeTypeSet(Collection<Class<?>> types) {
        return TypeSet.treeTypeSet(true, types);
    }

    public static TypeSet treeTypeSet(boolean autobox, Collection<Class<?>> types) {
        return TypeSet.treeTypeSet(autobox, (Class[])types.toArray(Class[]::new));
    }

    public static TypeSet treeTypeSet(Class<?> ... types) {
        return TypeSet.treeTypeSet(true, types);
    }

    public static TypeSet treeTypeSet(final boolean autobox, final Class<?> ... types) {
        Check.notNull(types);
        return new AbstractTypeSet(){

            @Override
            TypeMap<Object> createBackend() {
                return ((TreeTypeMapBuilder)((TreeTypeMapBuilder)new TreeTypeMapBuilder().autobox(autobox)).addMultiple(Boolean.TRUE, types)).freeze();
            }
        };
    }

    public static Set<Class<?>> prettySort(Collection<Class<?>> src) {
        ((Collection)Check.notNull(src).ok()).forEach(c -> Check.notNull((Object)c, (String)"collection must not contain null values"));
        Class[] types = (Class[])src.toArray(Class[]::new);
        Arrays.sort(types, new PrettyTypeComparator());
        return ArraySet.of(types);
    }
}

