/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.fallible.FallibleBiFunction;
import org.klojang.convert.TypeConversionException;
import org.klojang.invoke.BeanReader;
import org.klojang.invoke.IllegalAssignmentException;
import org.klojang.invoke.IncludeExclude;
import org.klojang.invoke.NoPublicSettersException;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.invoke.Setter;
import org.klojang.invoke.SetterFactory;

public final class BeanWriter<T> {
    private final Class<T> beanClass;
    private final FallibleBiFunction<Setter, Object, Object, Throwable> converter;
    private final Map<String, Setter> setters;
    private BeanReader<T> beanReader;

    public BeanWriter(Class<T> beanClass, String ... properties) {
        this(beanClass, IncludeExclude.INCLUDE, properties);
    }

    public BeanWriter(Class<T> beanClass, FallibleBiFunction<Setter, Object, Object, Throwable> converter, String ... properties) {
        this(beanClass, converter, IncludeExclude.INCLUDE, properties);
    }

    public BeanWriter(Class<T> beanClass, IncludeExclude includeExclude, String ... properties) {
        this.beanClass = (Class)Check.notNull(beanClass, (String)"beanClass").ok();
        this.converter = null;
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.notNull((Object)properties, (String)"properties");
        this.setters = this.getSetters(includeExclude, properties);
    }

    public BeanWriter(Class<T> beanClass, FallibleBiFunction<Setter, Object, Object, Throwable> converter, IncludeExclude includeExclude, String ... properties) {
        this.beanClass = (Class)Check.notNull(beanClass, (String)"beanClass").ok();
        this.converter = (FallibleBiFunction)Check.notNull(converter, (String)"converter").ok();
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.notNull((Object)properties, (String)"properties");
        this.setters = this.getSetters(includeExclude, properties);
    }

    public void write(T bean, String property, Object value) throws Throwable {
        Check.notNull(bean, (String)"bean");
        Setter setter = (Setter)Check.notNull((Object)property, (String)"property").ok(this.setters::get);
        Check.that((Object)setter).is((Predicate)CommonChecks.notNull(), () -> NoSuchPropertyException.noSuchProperty(bean, property));
        this.set(bean, setter, value);
    }

    public void copy(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            this.set(toBean, setter, reader.read(fromBean, setter.getProperty()));
        }
    }

    public void copyNonNull(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            Object v = reader.read(fromBean, setter.getProperty());
            if (v == null) continue;
            this.set(toBean, setter, v);
        }
    }

    public void enrich(T fromBean, T toBean) throws Throwable {
        Check.notNull(fromBean, (String)"source bean");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Setter setter : this.setters.values()) {
            Object v = reader.read(fromBean, setter.getProperty());
            if (v == null || reader.read(toBean, setter.getProperty()) != null) continue;
            this.set(toBean, setter, v);
        }
    }

    public void copy(Map<String, ?> fromMap, T toBean) throws IllegalAssignmentException, Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getKey() == null || (setter = this.setters.get(e.getKey())) == null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public void copyNonNull(Map<String, ?> fromMap, T toBean) throws Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getValue() == null || e.getKey() == null || (setter = this.setters.get(e.getKey())) == null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public void enrich(Map<String, ?> fromMap, T toBean) throws IllegalAssignmentException, Throwable {
        Check.notNull(fromMap, (String)"source map");
        Check.notNull(toBean, (String)"target bean");
        BeanReader<T> reader = this.getBeanReader();
        for (Map.Entry<String, ?> e : fromMap.entrySet()) {
            Setter setter;
            if (e.getValue() == null || e.getKey() == null || (setter = this.setters.get(e.getKey())) == null || reader.read(toBean, e.getKey()) != null) continue;
            this.set(toBean, setter, e.getValue());
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public boolean canWrite(String property) {
        return this.setters.keySet().contains(property);
    }

    public Set<String> getWritableProperties() {
        return this.setters.keySet();
    }

    public Map<String, Setter> getIncludedSetters() {
        return this.setters;
    }

    private Map<String, Setter> getSetters(IncludeExclude ie, String[] props) {
        Map<String, Setter> tmp = SetterFactory.INSTANCE.getSetters(this.beanClass);
        if (props.length != 0) {
            tmp = new HashMap<String, Setter>(tmp);
            if (ie.isExclude()) {
                tmp.keySet().removeAll(Set.of(props));
            } else {
                tmp.keySet().retainAll(Set.of(props));
            }
            Check.that(tmp).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicSettersException(this.beanClass));
            tmp = Map.copyOf(tmp);
        }
        return tmp;
    }

    private void set(T bean, Setter setter, Object value) throws Throwable {
        if (this.converter == null) {
            setter.write(bean, value);
        } else {
            Object val;
            try {
                val = this.converter.apply((Object)setter, value);
            }
            catch (TypeConversionException e) {
                throw setter.illegalAssignment(value);
            }
            setter.write(bean, val);
        }
    }

    private BeanReader<T> getBeanReader() {
        if (this.beanReader == null) {
            this.beanReader = new BeanReader<T>(this.beanClass, (String[])this.setters.keySet().toArray(String[]::new));
        }
        return this.beanReader;
    }
}

