/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.klojang.invoke.IllegalAssignmentException;
import org.klojang.util.ExceptionMethods;

public final class Setter {
    private final Class<?> declaredIn;
    private final Class<?> paramType;
    private final MethodHandle mh;
    private final String property;

    Setter(Method method, String property) {
        this.declaredIn = method.getDeclaringClass();
        this.paramType = method.getParameterTypes()[0];
        this.property = property;
        try {
            this.mh = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMethods.uncheck((Throwable)e);
        }
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getParamType() {
        return this.paramType;
    }

    public void write(Object bean, Object value) throws IllegalAssignmentException, Throwable {
        if (value == null && this.getParamType().isPrimitive()) {
            throw this.illegalAssignment(null);
        }
        try {
            this.mh.invoke(bean, value);
        }
        catch (ClassCastException e) {
            throw this.illegalAssignment(value);
        }
    }

    public IllegalAssignmentException illegalAssignment(Object value) {
        return new IllegalAssignmentException(this.declaredIn, this.property, this.getParamType(), value);
    }
}

