/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.check.aux.Emptyable;
import org.klojang.convert.NumberMethods;
import org.klojang.util.ArrayMethods;

public final class Path
implements Comparable<Path>,
Iterable<String>,
Emptyable {
    private static final Path EMPTY_PATH = new Path();
    private static final char SEP = '.';
    private static final char ESC = '^';
    private static final String NULL_SEGMENT = "^0";
    private final String[] elems;
    private String str;
    private int hash;

    public static Path from(String path) {
        Check.notNull((Object)path, (String)"path");
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        return new Path(path);
    }

    public static Path empty() {
        return EMPTY_PATH;
    }

    public static Path of(String segment) {
        return new Path(new String[]{segment});
    }

    public static Path of(String segment0, String segment1) {
        return new Path(new String[]{segment0, segment1});
    }

    public static Path of(String segment0, String segment1, String segment2) {
        return new Path(new String[]{segment0, segment1, segment2});
    }

    public static Path of(String segment0, String segment1, String segment2, String segment3) {
        return new Path(new String[]{segment0, segment1, segment2, segment3});
    }

    public static Path of(String segment0, String segment1, String segment2, String segment3, String segment4) {
        return new Path(new String[]{segment0, segment1, segment2, segment3, segment4});
    }

    public static Path of(String ... segments) {
        return Path.ofSegments(segments);
    }

    public static Path ofSegments(String[] segments) {
        Check.notNull((Object)segments);
        return segments.length == 0 ? EMPTY_PATH : new Path(segments);
    }

    public static Path copyOf(Path other) {
        return other == EMPTY_PATH ? other : (Path)Check.notNull((Object)other).ok(Path::new);
    }

    public static String escape(String segment) {
        if (segment == null) {
            return NULL_SEGMENT;
        }
        int x = segment.indexOf(46);
        if (x == -1) {
            return segment;
        }
        StringBuilder sb = new StringBuilder(segment.length() + 5);
        sb.append(segment, 0, x);
        for (int i = x; i < segment.length(); ++i) {
            if (segment.charAt(i) == '.') {
                sb.append('^').append('.');
                continue;
            }
            sb.append(segment.charAt(i));
        }
        return sb.toString();
    }

    private Path() {
        this.elems = ArrayMethods.EMPTY_STRING_ARRAY;
    }

    private Path(String path) {
        this.str = path;
        this.elems = Path.parse(this.str);
    }

    private Path(String[] segments) {
        this.elems = new String[segments.length];
        System.arraycopy(segments, 0, this.elems, 0, segments.length);
    }

    private Path(Path other) {
        this.elems = other.elems;
        this.str = other.str;
        this.hash = other.hash;
    }

    public String segment(int index) {
        if (index < 0) {
            return (String)Check.that((int)(this.elems.length + index)).is(CommonChecks.indexOf(), (Object)this.elems).mapToObj(x -> this.elems[x]);
        }
        return (String)Check.that((int)index).is(CommonChecks.indexOf(), (Object)this.elems).mapToObj(x -> this.elems[x]);
    }

    public Path subPath(int offset) {
        int from = offset < 0 ? this.elems.length + offset : offset;
        Check.that((int)from).is(CommonChecks.lt(), this.elems.length);
        return new Path(Arrays.copyOfRange(this.elems, from, this.elems.length));
    }

    public Path subPath(int offset, int length) {
        if (offset < 0) {
            offset = this.elems.length + offset;
        }
        Check.offsetLength((int)this.elems.length, (int)offset, (int)length);
        return new Path(Arrays.copyOfRange(this.elems, offset, offset + length));
    }

    public Path parent() {
        if (this.elems.length == 0) {
            return null;
        }
        if (this.elems.length == 1) {
            return EMPTY_PATH;
        }
        String[] segments = Arrays.copyOfRange(this.elems, 0, this.elems.length - 1);
        return new Path(segments);
    }

    public Path getCanonicalPath() {
        String[] canonical = (String[])this.stream().filter(Predicate.not(NumberMethods::isInt)).toArray(String[]::new);
        return canonical.length == 0 ? EMPTY_PATH : new Path(canonical);
    }

    public Path append(String path) {
        Check.notNull((Object)path);
        return this.append(new Path(Path.parse(path)));
    }

    public Path append(Path other) {
        Check.notNull((Object)other);
        return new Path((String[])ArrayMethods.concat((Object[])this.elems, (Object[])other.elems));
    }

    public Path replace(int index, String newValue) {
        Check.on((Function)CommonExceptions.INDEX, (int)index, (String)"index").is(CommonChecks.indexOf(), (Object)this.elems);
        String[] copy = Arrays.copyOf(this.elems, this.elems.length);
        copy[index] = newValue;
        return new Path(copy);
    }

    public Path shift() {
        String[] elems = this.elems;
        Check.on((Function)CommonExceptions.STATE, (int)this.elems.length).is(CommonChecks.ne(), 0, "empty path", new Object[0]);
        if (elems.length == 1) {
            return EMPTY_PATH;
        }
        String[] shifted = new String[elems.length - 1];
        System.arraycopy(elems, 1, shifted, 0, elems.length - 1);
        return new Path(shifted);
    }

    public Path reverse() {
        String[] elems = this.elems;
        if (this.elems.length > 1) {
            String[] segments = new String[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                segments[i] = elems[elems.length - 1 - i];
            }
            return new Path(segments);
        }
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < Path.this.elems.length;
            }

            @Override
            public String next() {
                if (this.i < Path.this.elems.length) {
                    return Path.this.elems[this.i++];
                }
                throw new IndexOutOfBoundsException(this.i);
            }
        };
    }

    public Stream<String> stream() {
        return Arrays.stream(this.elems);
    }

    public int size() {
        return this.elems.length;
    }

    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Path)) return false;
        Path p = (Path)obj;
        if (!Arrays.equals(this.elems, p.elems)) return false;
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.deepHashCode(this.elems);
        }
        return this.hash;
    }

    @Override
    public int compareTo(Path other) {
        Check.notNull((Object)other);
        return Arrays.compare((Comparable[])this.elems, (Comparable[])other.elems);
    }

    public String toString() {
        if (this.str == null) {
            this.str = ArrayMethods.implode((Object[])this.elems, Path::escape, (String)".", (int)0, (int)this.elems.length);
        }
        return this.str;
    }

    private static String[] parse(String path) {
        ArrayList<String> elems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < path.length(); ++i) {
            switch (path.charAt(i)) {
                case '.': {
                    String s = sb.toString();
                    elems.add(s.equals(NULL_SEGMENT) ? null : s);
                    sb.setLength(0);
                    continue block4;
                }
                case '^': {
                    if (i < path.length() - 1 && path.charAt(i + 1) == '.') {
                        sb.append('.');
                        ++i;
                        continue block4;
                    }
                    sb.append('^');
                    continue block4;
                }
                default: {
                    sb.append(path.charAt(i));
                }
            }
        }
        if (sb.length() > 0) {
            String s = sb.toString();
            elems.add(s.equals(NULL_SEGMENT) ? null : s);
        } else if (path.endsWith(".")) {
            elems.add("");
        }
        return (String[])elems.toArray(String[]::new);
    }
}

