/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.check.CommonProperties;
import org.klojang.check.aux.Result;
import org.klojang.check.relation.Relation;
import org.klojang.path.Path;
import org.klojang.util.ObjectMethods;

public final class MapBuilder {
    private static final Object _NULL_ = new Object();
    private static final String ERR_HOME_ALREADY = "already in root map";
    private final Map<String, Object> map;
    private final Path root;
    private final MapBuilder parent;

    public static MapBuilder begin() {
        return new MapBuilder();
    }

    public static MapBuilder begin(Map<String, Object> map) {
        return new MapBuilder(map);
    }

    public MapBuilder() {
        this(new LinkedHashMap<String, Object>());
    }

    public MapBuilder(Map<String, Object> map) {
        Check.notNull(map, (String)"map");
        this.map = new LinkedHashMap<String, Object>(map.size() + 10);
        this.root = Path.empty();
        this.parent = null;
        MapBuilder.init(this, map);
    }

    private MapBuilder(Path root, MapBuilder parent) {
        this.root = root;
        this.map = new LinkedHashMap<String, Object>();
        this.parent = parent;
    }

    public MapBuilder set(String path, Object value) {
        Check.notNull((Object)path, (String)"path");
        MapBuilder.set(this, Path.from(path), value);
        return this;
    }

    public MapBuilder add(String path, Object element) {
        Check.notNull((Object)path, (String)"path");
        Result<Object> result = this.poll(path);
        if (result.isAvailable()) {
            Check.on(PathBlockedException::new, (Object)result.get(), (String)path).is(CommonChecks.instanceOf(), Collection.class).then(o -> ((Collection)o).add(element));
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            this.set(path, list);
        }
        return this;
    }

    public Result<Object> poll(String path) {
        Check.notNull((Object)path, (String)"path");
        return MapBuilder.poll(this, Path.from(path));
    }

    public <T> T get(String path) {
        return (T)this.poll(path).orElse(null);
    }

    public MapBuilder in(String path) {
        Check.notNull((Object)path, (String)"path");
        return MapBuilder.in(this, Path.from(path));
    }

    public MapBuilder jump(String path) {
        return this.parent == null ? this.in(path) : this.reset().in(path);
    }

    public MapBuilder up(String parent) {
        Check.on((Function)CommonExceptions.STATE, (Object)this.parent).is((Predicate)CommonChecks.notNull(), ERR_HOME_ALREADY, new Object[0]);
        if (this.root.size() == 1) {
            Check.that((Object)parent).is((Predicate)CommonChecks.empty(), "specify null or \"\" to exit to root map", new Object[0]);
        } else {
            String actual = this.parent.root.segment(-1);
            Check.that((Object)parent).is(CommonChecks.EQ(), (Object)actual, "expected segment: \"${obj}\"; provided segment: \"${arg}\"", new Object[0]);
        }
        return this.parent;
    }

    public MapBuilder reset() {
        Check.on((Function)CommonExceptions.STATE, (Object)this.parent).is((Predicate)CommonChecks.notNull(), ERR_HOME_ALREADY, new Object[0]);
        MapBuilder mb = this.parent;
        while (mb.parent != null) {
            mb = mb.parent;
        }
        return mb;
    }

    public String where() {
        return this.root.toString();
    }

    public boolean isSet(String path) {
        Check.notNull((Object)path);
        return MapBuilder.isSet(this, Path.from(path));
    }

    public MapBuilder unset(String path) {
        Check.notNull((Object)path);
        MapBuilder.unset(this, Path.from(path));
        return this;
    }

    public Map<String, Object> createMap() {
        MapBuilder mb = this;
        while (mb.parent != null) {
            mb = mb.parent;
        }
        return MapBuilder.createMap(mb);
    }

    public String toString() {
        return this.createMap().toString();
    }

    private static void init(MapBuilder writer, Map map) {
        map.forEach((key, val) -> MapBuilder.processEntry(writer, key, val));
    }

    private static void processEntry(MapBuilder writer, Object key, Object val) {
        Check.that((Object)key).isNot((Predicate)CommonChecks.NULL(), "illegal null key in source map", new Object[0]).isNot((Predicate)CommonChecks.empty(), "illegal empty key in source map", new Object[0]).is(CommonChecks.instanceOf(), String.class, "illegal key type in source map: ${type}", new Object[0]);
        String k = key.toString();
        if (val instanceof Map) {
            Map nested = (Map)val;
            Path path = writer.root.append(k);
            MapBuilder mb = new MapBuilder(path, writer);
            writer.map.put(k, mb);
            MapBuilder.init(mb, nested);
        } else {
            Check.that((Object)val).isNot(CommonChecks.instanceOf(), MapBuilder.class);
            writer.map.put(k, ObjectMethods.ifNull((Object)val, (Object)_NULL_));
        }
    }

    private static void set(MapBuilder writer, Path path, Object val) {
        String key = MapBuilder.firstSegment(path);
        if (path.size() == 1) {
            if (writer.map.containsKey(key)) {
                throw MapBuilder.alreadySet(writer, key);
            }
            Check.that((Object)val, (String)"value").isNot(CommonChecks.instanceOf(), Map.class).isNot(CommonChecks.instanceOf(), MapBuilder.class);
            writer.map.put(key, ObjectMethods.ifNull((Object)val, (Object)_NULL_));
        } else {
            MapBuilder.set(MapBuilder.getNestedWriter(writer, key), path.shift(), val);
        }
    }

    private static Result<Object> poll(MapBuilder writer, Path path) {
        String key = path.segment(0);
        Object val = writer.map.get(key);
        if (val instanceof MapBuilder) {
            MapBuilder nested = (MapBuilder)val;
            if (path.size() == 1) {
                return Result.of(MapBuilder.createMap(nested));
            }
            return MapBuilder.poll(nested, path.shift());
        }
        if (path.size() == 1 && val != null) {
            return Result.of((Object)ObjectMethods.replaceIf((Object)val, (Relation)CommonChecks.sameAs(), (Object)_NULL_, null));
        }
        return Result.notAvailable();
    }

    private static MapBuilder in(MapBuilder writer, Path path) {
        if (path.isEmpty()) {
            return writer;
        }
        String key = MapBuilder.firstSegment(path);
        return MapBuilder.in(MapBuilder.getNestedWriter(writer, key), path.shift());
    }

    private static boolean isSet(MapBuilder writer, Path path) {
        String key = MapBuilder.firstSegment(path);
        Object val = writer.map.get(key);
        if (val == null) {
            return false;
        }
        if (path.size() == 1 || !(val instanceof MapBuilder)) {
            return true;
        }
        return MapBuilder.isSet((MapBuilder)val, path.shift());
    }

    private static void unset(MapBuilder writer, Path path) {
        String key = MapBuilder.firstSegment(path);
        if (path.size() == 1) {
            writer.map.remove(key);
        } else {
            MapBuilder.unset(MapBuilder.getNestedWriter(writer, key), path.shift());
        }
    }

    private static Map<String, Object> createMap(MapBuilder writer) {
        int sz = 1 + 4 * writer.map.size() / 3;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(sz);
        writer.map.forEach((key, val) -> {
            if (val instanceof MapBuilder) {
                MapBuilder mb = (MapBuilder)val;
                m.put((String)key, MapBuilder.createMap(mb));
            } else {
                m.put((String)key, ObjectMethods.replaceIf((Object)val, (Relation)CommonChecks.sameAs(), (Object)_NULL_, null));
            }
        });
        return m;
    }

    private static MapBuilder getNestedWriter(MapBuilder writer, String key) {
        Path root = writer.root.append(key);
        Object val = writer.map.computeIfAbsent(key, k -> new MapBuilder(root, writer));
        if (val instanceof MapBuilder) {
            MapBuilder mb = (MapBuilder)val;
            return mb;
        }
        throw new PathBlockedException(root, val);
    }

    private static PathBlockedException alreadySet(MapBuilder writer, String key) {
        Path absPath = writer.root.append(key);
        Object curVal = writer.map.get(key);
        return new PathBlockedException(absPath, curVal);
    }

    private static String firstSegment(Path path) {
        return (String)Check.that((Object)path.segment(0)).isNot((Predicate)CommonChecks.NULL(), "illegal null segment in path \"${0}\"", new Object[]{path}).has(CommonProperties.strlen(), CommonChecks.gt(), 0, "illegal empty segment in path \"${0}\"", new Object[]{path}).ok();
    }

    public static class PathBlockedException
    extends IllegalArgumentException {
        private PathBlockedException(Path path, Object value) {
            super(PathBlockedException.createMessage(path, value));
        }

        private PathBlockedException(String msg) {
            super(msg);
        }

        private static String createMessage(Path path, Object value) {
            String fmt = "path \"%s\" blocked by terminal value %s";
            if (value instanceof String) {
                String s = (String)value;
                value = "\"" + s + "\"";
            }
            return String.format(fmt, path, value);
        }
    }
}

