/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.BeanReaderBuilder;
import org.klojang.invoke.Getter;
import org.klojang.invoke.GetterFactory;
import org.klojang.invoke.IncludeExclude;
import org.klojang.invoke.NoPublicGettersException;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.invoke.Private;

public final class BeanReader<T> {
    private final Class<T> beanClass;
    private final Map<String, Getter> getters;

    public static <T> BeanReaderBuilder<T> forClass(Class<T> beanClass) {
        return new BeanReaderBuilder<T>(beanClass);
    }

    public BeanReader(Class<T> beanClass, String ... properties) {
        this(beanClass, true, IncludeExclude.INCLUDE, properties);
    }

    public BeanReader(Class<T> beanClass, IncludeExclude includeExclude, String ... properties) {
        this(beanClass, true, includeExclude, properties);
    }

    public BeanReader(Class<T> beanClass, boolean strictNaming, IncludeExclude includeExclude, String ... properties) {
        Check.notNull(beanClass, (String)"beanClass");
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.that((Object)properties, (String)"properties").is((Predicate)CommonChecks.deepNotNull());
        this.beanClass = beanClass;
        this.getters = this.getGetters(strictNaming, includeExclude, properties);
    }

    BeanReader(Class<T> beanClass, Map<String, Getter> getters) {
        this.beanClass = beanClass;
        this.getters = getters;
    }

    public <U> U read(T bean, String property) throws NoSuchPropertyException {
        Check.notNull(bean, (String)"bean");
        Check.notNull((Object)property, (String)"property");
        Getter getter = this.getters.get(property);
        Check.that((Object)getter).is((Predicate)CommonChecks.notNull(), () -> NoSuchPropertyException.noSuchProperty(bean, property));
        try {
            return (U)getter.read(bean);
        }
        catch (Throwable exc) {
            throw Private.wrap(exc, bean, getter);
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public boolean canRead(String property) {
        return this.getters.containsKey(property);
    }

    public Set<String> getReadableProperties() {
        return this.getters.keySet();
    }

    public Map<String, Getter> getIncludedGetters() {
        return this.getters;
    }

    private Map<String, Getter> getGetters(boolean strictNaming, IncludeExclude ie, String[] props) {
        Map<String, Getter> tmp = GetterFactory.INSTANCE.getGetters(this.beanClass, strictNaming);
        if (props.length != 0) {
            tmp = new HashMap<String, Getter>(tmp);
            if (ie.isExclude()) {
                tmp.keySet().removeAll(Set.of(props));
            } else {
                tmp.keySet().retainAll(Set.of(props));
            }
            Check.that(tmp).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicGettersException(this.beanClass));
            tmp = Map.copyOf(tmp);
        }
        return tmp;
    }
}

