/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.BeanReaderBuilder;
import org.klojang.invoke.BeanValueTransformer;
import org.klojang.invoke.Getter;
import org.klojang.invoke.GetterFactory;
import org.klojang.invoke.IncludeExclude;
import org.klojang.invoke.NoPublicGettersException;
import org.klojang.invoke.NoSuchPropertyException;
import org.klojang.invoke.Private;

public final class BeanReader<T> {
    private final Class<T> beanClass;
    private final Map<String, Getter> getters;
    private final BeanValueTransformer<T> transformer;

    public static <T> BeanReaderBuilder<T> forClass(Class<T> beanClass) {
        return new BeanReaderBuilder<T>(beanClass);
    }

    public BeanReader(Class<T> beanClass, String ... properties) {
        this(beanClass, true, IncludeExclude.INCLUDE, properties);
    }

    public BeanReader(Class<T> beanClass, IncludeExclude includeExclude, String ... properties) {
        this(beanClass, true, includeExclude, properties);
    }

    public BeanReader(Class<T> beanClass, boolean strictNaming, IncludeExclude includeExclude, String ... properties) {
        this(beanClass, strictNaming, BeanValueTransformer.identity(), includeExclude, properties);
    }

    public BeanReader(Class<T> beanClass, boolean strictNaming, BeanValueTransformer<T> transformer, IncludeExclude includeExclude, String ... properties) {
        Check.notNull(beanClass, (String)"beanClass");
        Check.notNull(transformer, (String)"transformer");
        Check.notNull((Object)((Object)includeExclude), (String)"includeExclude");
        Check.that((Object)properties, (String)"properties").is((Predicate)CommonChecks.deepNotNull());
        this.beanClass = beanClass;
        this.transformer = transformer;
        this.getters = this.getGetters(strictNaming, includeExclude, properties);
    }

    BeanReader(Class<T> beanClass, Map<String, Getter> getters, BeanValueTransformer<T> transformer) {
        this.beanClass = beanClass;
        this.getters = getters;
        this.transformer = transformer;
    }

    public <U> U read(T bean, String property) throws NoSuchPropertyException {
        Object val;
        Check.notNull(bean, (String)"bean");
        Check.notNull((Object)property, (String)"property");
        Getter getter = this.getters.get(property);
        Check.that((Object)getter).is((Predicate)CommonChecks.notNull(), () -> NoSuchPropertyException.noSuchProperty(bean, property));
        try {
            val = getter.read(bean);
        }
        catch (Throwable exc) {
            throw Private.wrap(exc, bean, getter);
        }
        if (this.transformer != null) {
            val = this.transformer.transform(bean, property, val);
        }
        return (U)val;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public boolean canRead(String property) {
        return this.getters.containsKey(property);
    }

    public Set<String> getReadableProperties() {
        return this.getters.keySet();
    }

    public Map<String, Getter> getIncludedGetters() {
        return this.getters;
    }

    private Map<String, Getter> getGetters(boolean strict, IncludeExclude ie, String[] props) {
        LinkedHashMap<String, Getter> tmp;
        Map<String, Getter> m = GetterFactory.INSTANCE.getGetters(this.beanClass, strict);
        if (props.length == 0) {
            return m;
        }
        if (ie.isExclude()) {
            Set<String> propSet = Set.of(props);
            tmp = LinkedHashMap.newLinkedHashMap(m.size() - props.length);
            m.forEach((x, y) -> {
                if (!propSet.contains(x)) {
                    tmp.put((String)x, (Getter)y);
                }
            });
        } else {
            tmp = LinkedHashMap.newLinkedHashMap(props.length);
            for (String prop : props) {
                if (!m.containsKey(prop)) continue;
                tmp.put(prop, m.get(prop));
            }
        }
        Check.that(tmp).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicGettersException(this.beanClass));
        return tmp;
    }
}

