/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.klojang.util.ExceptionMethods;

public final class Getter {
    private final Class<?> returnType;
    private final MethodHandle mh;
    private final String property;

    Getter(Method method, String property) {
        this.returnType = method.getReturnType();
        this.property = property;
        try {
            this.mh = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMethods.uncheck((Throwable)e);
        }
    }

    Getter(MethodHandle mh, String property, Class<?> returnType) {
        this.mh = mh;
        this.property = property;
        this.returnType = returnType;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Object read(Object bean) throws Throwable {
        return this.mh.invoke(bean);
    }
}

