/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Map;
import org.klojang.path.KeyDeserializationException;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.SegmentWriter;

final class MapSegmentWriter
extends SegmentWriter<Map> {
    MapSegmentWriter(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    boolean write(Map map, Path path, Object value) {
        Object key;
        int segment = path.size() - 1;
        if (this.kd == null) {
            key = path.segment(segment);
        } else {
            try {
                key = this.kd.deserialize(path, segment);
            }
            catch (KeyDeserializationException e) {
                return this.deadEnd(PathWalkerException.keyDeserializationFailed(path, segment, e));
            }
        }
        try {
            map.put(key, value);
        }
        catch (UnsupportedOperationException e) {
            return this.deadEnd(PathWalkerException.notModifiable(path, segment, Map.class));
        }
        return true;
    }
}

