/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Collection;
import java.util.Map;
import org.klojang.path.ArraySegmentReader;
import org.klojang.path.BeanSegmentReader;
import org.klojang.path.CollectionSegmentReader;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.MapSegmentReader;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.PrimitiveArraySegmentReader;
import org.klojang.util.ClassMethods;

final class ObjectReader {
    private final boolean se;
    private final KeyDeserializer kd;

    ObjectReader(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        this.se = suppressExceptions;
        this.kd = keyDeserializer;
    }

    Object read(Object obj, Path path, int segment) {
        if (segment == path.size()) {
            return obj;
        }
        if (obj == null) {
            return this.deadEnd(PathWalkerException.nullValue(path, segment));
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            return new CollectionSegmentReader(this.se, this.kd).read(c, path, segment);
        }
        if (obj instanceof Object[]) {
            Object[] o = (Object[])obj;
            return new ArraySegmentReader(this.se, this.kd).read(o, path, segment);
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            return new MapSegmentReader(this.se, this.kd).read(m, path, segment);
        }
        if (ClassMethods.isPrimitiveArray((Object)obj)) {
            return new PrimitiveArraySegmentReader(this.se, this.kd).read(obj, path, segment);
        }
        return new BeanSegmentReader(this.se, this.kd).read(obj, path, segment);
    }

    Object deadEnd(PathWalkerException.Factory excFactory) {
        if (this.se) {
            return null;
        }
        throw (PathWalkerException)excFactory.get();
    }
}

