/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.Map;
import org.klojang.path.KeyDeserializationException;
import org.klojang.path.KeyDeserializer;
import org.klojang.path.ObjectReader;
import org.klojang.path.Path;
import org.klojang.path.PathWalkerException;
import org.klojang.path.SegmentReader;

final class MapSegmentReader
extends SegmentReader<Map<?, ?>> {
    MapSegmentReader(boolean suppressExceptions, KeyDeserializer keyDeserializer) {
        super(suppressExceptions, keyDeserializer);
    }

    @Override
    Object read(Map<?, ?> map, Path path, int segment) {
        Object key;
        if (this.kd == null) {
            key = path.segment(segment);
        } else {
            try {
                key = this.kd.deserialize(path, segment);
            }
            catch (KeyDeserializationException e) {
                return this.deadEnd(PathWalkerException.keyDeserializationFailed(path, segment, e));
            }
        }
        Object val = map.get(key);
        if (val == null && !map.containsKey(key)) {
            return this.deadEnd(PathWalkerException.noSuchKey(path, segment, key));
        }
        return new ObjectReader(this.se, this.kd).read(val, path, ++segment);
    }
}

