/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.util.function.Supplier;
import org.klojang.path.ErrorCode;
import org.klojang.path.KeyDeserializationException;
import org.klojang.path.Path;
import org.klojang.util.ClassMethods;

public final class PathWalkerException
extends RuntimeException {
    private static final String INVALID_PATH = "invalid path: \"%s\" (segment %d)";
    private static final String PATH_SEGMENT = "path %s, segment %s: ";
    private final ErrorCode errorCode;

    static Factory noSuchProperty(Path path, int segment, Class<?> clazz) {
        String fmt = "invalid path: \"%s\" (segment %d) *** no accessible property named \"%s\" in %s.class";
        String className = ClassMethods.className(clazz);
        String msg = String.format(fmt, path, segment + 1, path.segment(segment), className);
        return () -> new PathWalkerException(ErrorCode.NO_SUCH_PROPERTY, msg);
    }

    static Factory noSuchKey(Path path, int segment, Object key) {
        String fmt = "invalid path: \"%s\" (segment %d) *** no such key: \"%s\"";
        String msg = String.format(fmt, path, segment + 1, path.segment(segment));
        return () -> new PathWalkerException(ErrorCode.NO_SUCH_KEY, msg);
    }

    static Factory indexExpected(Path path, int segment) {
        String fmt = "invalid path: \"%s\" (segment %d) *** array index expected; found: \"%s\"";
        String msg = String.format(fmt, path, segment + 1, path.segment(segment));
        return () -> new PathWalkerException(ErrorCode.INDEX_EXPECTED, msg);
    }

    static Factory indexOutOfBounds(Path path, int segment) {
        String fmt = "invalid path: \"%s\" (segment %d) *** index out of bounds: %s";
        String msg = String.format(fmt, path, segment + 1, path.segment(segment));
        return () -> new PathWalkerException(ErrorCode.INDEX_OUT_OF_BOUNDS, msg);
    }

    static Factory nullValue(Path path, int segment) {
        String fmt = "invalid path: \"%s\" (segment %d) *** terminal value encountered at segment \"%s\": null";
        String msg = String.format(fmt, path, segment + 1, path.segment(segment));
        return () -> new PathWalkerException(ErrorCode.TERMINAL_VALUE, msg);
    }

    static Factory terminalValue(Path path, int segment, Object value) {
        String fmt = "invalid path: \"%s\" (segment %d) *** terminal value encountered at segment \"%s\": (%s) %s";
        String className = ClassMethods.simpleClassName(value.getClass());
        String msg = String.format(fmt, path, segment + 1, path.segment(segment), className, value);
        return () -> new PathWalkerException(ErrorCode.TERMINAL_VALUE, msg);
    }

    static Factory emptySegment(Path path, int segment) {
        String fmt = "invalid path: \"%s\" (segment %d) *** segment must not be null or empty";
        String msg = String.format(fmt, path, segment + 1);
        return () -> new PathWalkerException(ErrorCode.EMPTY_SEGMENT, msg);
    }

    static Factory typeMismatch(Path path, int segment, String message) {
        String fmt = "path %s, segment %s: %s";
        String msg = String.format(fmt, path, segment + 1, message);
        return () -> new PathWalkerException(ErrorCode.TYPE_MISMATCH, msg);
    }

    static Factory typeMismatch(Path path, int segment, Class expected, Class actual) {
        String fmt = "path %s, segment %s: cannot assign %s to %s";
        String scn0 = ClassMethods.simpleClassName((Class)expected);
        String scn1 = ClassMethods.simpleClassName((Class)actual);
        String msg = String.format(fmt, path, segment + 1, scn0, scn1);
        return () -> new PathWalkerException(ErrorCode.TYPE_MISMATCH, msg);
    }

    static Factory notModifiable(Path path, int segment, Class<?> type) {
        String fmt = "path %s, segment %s: %s implementation encountered at segment \"%s\" appears to be unmodifiable";
        String msg = String.format(fmt, path, segment + 1, ClassMethods.simpleClassName(type), path.segment(segment));
        return () -> new PathWalkerException(ErrorCode.NOT_MODIFIABLE, msg);
    }

    static Factory keyDeserializationFailed(Path path, int segment, KeyDeserializationException exc) {
        if (exc.getMessage() == null) {
            String fmt = "invalid path: \"%s\" (segment %d) *** failed to deserialize \"%s\" into map key";
            String msg = String.format(fmt, path, segment + 1, path.segment(segment));
            return () -> new PathWalkerException(ErrorCode.KEY_DESERIALIZATION_FAILED, msg);
        }
        String fmt = "invalid path: \"%s\" (segment %d) *** %s";
        String msg = String.format(fmt, path, segment + 1, exc.getMessage());
        return () -> new PathWalkerException(ErrorCode.KEY_DESERIALIZATION_FAILED, msg);
    }

    static Factory unexpectedError(Path path, int segment, Throwable t) {
        String fmt = "path %s, segment %s: unexpected error *** %s";
        String msg = String.format(fmt, path, segment + 1, t);
        return () -> new PathWalkerException(ErrorCode.EXCEPTION, msg);
    }

    private PathWalkerException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    static interface Factory
    extends Supplier<PathWalkerException> {
    }
}

