/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.BeanReader;
import org.klojang.invoke.BeanValueTransformer;
import org.klojang.invoke.Getter;
import org.klojang.invoke.NoPublicGettersException;
import org.klojang.util.InvokeException;

public final class BeanReaderBuilder<T> {
    private final Class<T> clazz;
    private final Map<String, Getter> getters = new HashMap<String, Getter>();
    private BeanValueTransformer<T> transformer = BeanValueTransformer.identity();

    BeanReaderBuilder(Class<T> beanClass) {
        this.clazz = beanClass;
    }

    public BeanReaderBuilder<T> withInt(String ... properties) {
        return this.with(Integer.TYPE, properties);
    }

    public BeanReaderBuilder<T> withString(String ... properties) {
        return this.with(String.class, properties);
    }

    public BeanReaderBuilder<T> with(Class<?> type, String ... properties) {
        Check.notNull(type, (String)"type");
        Check.notNull((Object)properties, (String)"properties");
        for (String prop : properties) {
            Check.on(InvokeException::new, (Object)prop).isNot(CommonChecks.keyIn(), this.getters, "duplicate property: \"${arg}\"", new Object[0]);
            String method = this.getMethodNameFromProperty(prop, type);
            Getter getter = this.getGetter(prop, method, type);
            this.getters.put(prop, getter);
        }
        return this;
    }

    public BeanReaderBuilder<T> withGetter(Class<?> returnType, String ... names) {
        Check.notNull(returnType, (String)"return type");
        Check.notNull((Object)names, (String)"names");
        for (String method : names) {
            String prop = this.getPropertyFromMethodName(method, returnType);
            Check.on(InvokeException::new, (Object)prop).isNot(CommonChecks.keyIn(), this.getters, "duplicate property: \"${arg}\"", new Object[0]);
            Getter getter = this.getGetter(prop, method, returnType);
            this.getters.put(prop, getter);
        }
        return this;
    }

    public BeanReaderBuilder<T> withTransformer(BeanValueTransformer<T> transformer) {
        Check.notNull(transformer, (String)"transformer");
        this.transformer = transformer;
        return this;
    }

    public BeanReader<T> build() throws NoPublicGettersException {
        Check.that(this.getters).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicGettersException(this.clazz));
        return new BeanReader<T>(this.clazz, Map.copyOf(this.getters), this.transformer);
    }

    private Getter getGetter(String property, String method, Class<?> type) {
        try {
            MethodHandle mh = MethodHandles.publicLookup().findVirtual(this.clazz, method, MethodType.methodType(type));
            return new Getter(mh, property, type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new InvokeException(e.toString());
        }
    }

    private String getPropertyFromMethodName(String method, Class<?> type) {
        if (this.clazz.isRecord()) {
            return method;
        }
        if ((type == Boolean.TYPE || type == Boolean.class) && method.length() > 2 && method.startsWith("is") && Character.isUpperCase(method.charAt(2))) {
            return BeanReaderBuilder.extractName(method, 2);
        }
        if (method.length() > 3 && method.startsWith("get") && Character.isUpperCase(method.charAt(3))) {
            return BeanReaderBuilder.extractName(method, 3);
        }
        return method;
    }

    private String getMethodNameFromProperty(String prop, Class<?> type) {
        if (this.clazz.isRecord()) {
            return prop;
        }
        String methodName = type == Boolean.TYPE || type == Boolean.class ? (prop.length() > 1 ? "is" + Character.toUpperCase(prop.charAt(0)) + prop.substring(1) : "is" + Character.toUpperCase(prop.charAt(0))) : (prop.length() > 1 ? "get" + Character.toUpperCase(prop.charAt(0)) + prop.substring(1) : "get" + Character.toUpperCase(prop.charAt(0)));
        return methodName;
    }

    private static String extractName(String n, int from) {
        StringBuilder sb = new StringBuilder(n.length() - 3);
        sb.append(n.substring(from));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }
}

