/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.invoke;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.invoke.NoPublicSettersException;
import org.klojang.invoke.Setter;
import org.klojang.util.ArrayMethods;
import org.klojang.util.ClassMethods;

public final class SetterFactory {
    public static final SetterFactory INSTANCE = new SetterFactory();
    private final Map<Class<?>, Map<String, Setter>> cache = new HashMap();

    private SetterFactory() {
    }

    public Map<String, Setter> getSetters(Class<?> clazz) {
        Map<String, Setter> setters = this.cache.get(clazz);
        if (setters == null) {
            List<Method> methods = SetterFactory.getMethods(clazz);
            Check.that(methods).isNot((Predicate)CommonChecks.empty(), () -> new NoPublicSettersException(clazz));
            LinkedHashMap<String, Setter> map = LinkedHashMap.newLinkedHashMap(methods.size());
            for (Method m : methods) {
                String prop = SetterFactory.getPropertyNameFromSetter(m);
                map.put(prop, new Setter(m, prop));
            }
            setters = Map.copyOf(map);
            this.cache.put(clazz, setters);
        }
        return setters;
    }

    private static List<Method> getMethods(Class<?> beanClass) {
        Method[] methods = beanClass.getMethods();
        ArrayList<Method> setters = new ArrayList<Method>();
        for (Method m : methods) {
            if (beanClass.isRecord() || Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1 || m.getReturnType() != Void.TYPE || !SetterFactory.isValidSetterName(m)) continue;
            setters.add(m);
        }
        return setters;
    }

    private static String getPropertyNameFromSetter(Method m) {
        String n = m.getName();
        if (n.startsWith("set") && Character.isUpperCase(n.charAt(3))) {
            return SetterFactory.extractName(n, 3);
        }
        throw SetterFactory.notAProperty(m);
    }

    private static String extractName(String n, int from) {
        StringBuilder sb = new StringBuilder(n.length() - 3);
        sb.append(n.substring(from));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    private static IllegalArgumentException notAProperty(Method m) {
        String fmt = "method %s %s(%s) in class %s is not a setter";
        String rt = ClassMethods.simpleClassName(m.getReturnType());
        String clazz = ClassMethods.className(m.getDeclaringClass());
        String params = ArrayMethods.implode((Object[])m.getParameterTypes(), ClassMethods::simpleClassName);
        String msg = String.format(fmt, rt, m.getName(), params, clazz);
        return new IllegalArgumentException(msg);
    }

    private static boolean isValidSetterName(Method m) {
        String n = m.getName();
        return n.length() > 3 && n.startsWith("set") && Character.isUpperCase(n.charAt(3));
    }
}

