/*
 * Decompiled with CFR 0.152.
 */
package org.klojang.path;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.klojang.check.Check;
import org.klojang.check.CommonChecks;
import org.klojang.check.CommonExceptions;
import org.klojang.check.aux.Emptyable;
import org.klojang.util.ArrayMethods;
import org.klojang.util.ObjectMethods;

public final class Path
implements Comparable<Path>,
Iterable<String>,
Emptyable {
    private static final Path EMPTY_PATH = new Path();
    private static final char SEP = '.';
    private static final char ESC = '^';
    private static final String NULL_SEGMENT = "^0";
    private final String[] elems;
    private String str;
    private int hash;

    public static Path from(String path) {
        Check.notNull((Object)path, (String)"path");
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        return new Path(path);
    }

    public static Path from(String[] segments) {
        Check.notNull((Object)segments);
        return segments.length == 0 ? EMPTY_PATH : new Path(segments);
    }

    public static Path empty() {
        return EMPTY_PATH;
    }

    public static Path of(String segment) {
        return new Path(new String[]{segment});
    }

    public static Path of(String segment0, String segment1) {
        return new Path(new String[]{segment0, segment1});
    }

    public static Path of(String segment0, String segment1, String segment2) {
        return new Path(new String[]{segment0, segment1, segment2});
    }

    public static Path of(String segment0, String segment1, String segment2, String segment3) {
        return new Path(new String[]{segment0, segment1, segment2, segment3});
    }

    public static Path of(String segment0, String segment1, String segment2, String segment3, String segment4) {
        return new Path(new String[]{segment0, segment1, segment2, segment3, segment4});
    }

    public static Path of(String ... segments) {
        return Path.from(segments);
    }

    public static Path copyOf(Path other) {
        return other == EMPTY_PATH ? other : (Path)Check.notNull((Object)other).ok(Path::new);
    }

    public static String escape(String segment) {
        if (segment == null) {
            return NULL_SEGMENT;
        }
        if (segment.equals(NULL_SEGMENT)) {
            return "^^0";
        }
        int x = segment.indexOf(46);
        if (x == -1) {
            return segment;
        }
        StringBuilder sb = new StringBuilder(segment.length() + 3).append(segment.substring(0, x)).append('^').append('.');
        block3: for (int i = x + 1; i < segment.length(); ++i) {
            char c = segment.charAt(i);
            switch (c) {
                case '.': {
                    sb.append('^').append('.');
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private Path() {
        this.elems = ArrayMethods.EMPTY_STRING_ARRAY;
    }

    private Path(String path) {
        this.str = path;
        this.elems = Path.parse(this.str);
    }

    private Path(String[] segments) {
        this.elems = new String[segments.length];
        System.arraycopy(segments, 0, this.elems, 0, segments.length);
    }

    private Path(Path other) {
        this.elems = other.elems;
        this.str = other.str;
        this.hash = other.hash;
    }

    public String segment(int index) {
        if (index < 0) {
            return (String)Check.that((int)(this.elems.length + index)).is(CommonChecks.indexOf(), (Object)this.elems).mapToObj(x -> this.elems[x]);
        }
        return (String)Check.that((int)index).is(CommonChecks.indexOf(), (Object)this.elems).mapToObj(x -> this.elems[x]);
    }

    public Path subPath(int offset) {
        int from = offset < 0 ? this.elems.length + offset : offset;
        Check.that((int)from).is(CommonChecks.lt(), this.elems.length);
        return new Path(Arrays.copyOfRange(this.elems, from, this.elems.length));
    }

    public Path subPath(int offset, int length) {
        if (offset < 0) {
            offset = this.elems.length + offset;
        }
        Check.offsetLength((int)this.elems.length, (int)offset, (int)length);
        return new Path(Arrays.copyOfRange(this.elems, offset, offset + length));
    }

    public Path shift() {
        return switch (this.elems.length) {
            case 0 -> null;
            case 1 -> EMPTY_PATH;
            default -> new Path(Arrays.copyOfRange(this.elems, 1, this.elems.length));
        };
    }

    public Path parent() {
        return switch (this.elems.length) {
            case 0 -> null;
            case 1 -> EMPTY_PATH;
            default -> new Path(Arrays.copyOfRange(this.elems, 0, this.elems.length - 1));
        };
    }

    public Path getCanonicalPath() {
        String[] canonical = (String[])this.stream().filter(s -> !s.chars().allMatch(Character::isDigit) || new BigInteger((String)s).intValueExact() < 0).toArray(String[]::new);
        return canonical.length == 0 ? EMPTY_PATH : new Path(canonical);
    }

    public Path append(String path) {
        Check.notNull((Object)path);
        return this.append(new Path(Path.parse(path)));
    }

    public Path append(Path other) {
        Check.notNull((Object)other);
        return new Path((String[])ArrayMethods.concat((Object[])this.elems, (Object[])other.elems));
    }

    public Path replace(int index, String newValue) {
        Check.on((Function)CommonExceptions.INDEX, (int)index, (String)"index").is(CommonChecks.indexOf(), (Object)this.elems);
        String[] copy = Arrays.copyOf(this.elems, this.elems.length);
        copy[index] = newValue;
        return new Path(copy);
    }

    public Path reverse() {
        String[] elems = this.elems;
        if (this.elems.length > 1) {
            String[] segments = new String[elems.length];
            int x = elems.length;
            for (int i = 0; i < elems.length; ++i) {
                segments[i] = elems[--x];
            }
            return new Path(segments);
        }
        return this;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < Path.this.elems.length;
            }

            @Override
            public String next() {
                if (this.i < Path.this.elems.length) {
                    return Path.this.elems[this.i++];
                }
                throw new IndexOutOfBoundsException(this.i);
            }
        };
    }

    public Stream<String> stream() {
        return Arrays.stream(this.elems);
    }

    public int size() {
        return this.elems.length;
    }

    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    public boolean isDeepNotEmpty() {
        return ObjectMethods.isDeepNotEmpty((Object[])this.elems);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Path)) return false;
        Path p = (Path)obj;
        if (!Arrays.equals(this.elems, p.elems)) return false;
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.deepHashCode(this.elems);
        }
        return this.hash;
    }

    @Override
    public int compareTo(Path other) {
        Check.notNull((Object)other);
        return Arrays.compare((Comparable[])this.elems, (Comparable[])other.elems);
    }

    public String toString() {
        if (this.str == null) {
            this.str = ArrayMethods.implode((Object[])this.elems, Path::escape, (String)".", (int)0, (int)this.elems.length);
        }
        return this.str;
    }

    private static String[] parse(String path) {
        ArrayList<String> elems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int len = path.length();
        block4: for (int i = 0; i < len; ++i) {
            switch (path.charAt(i)) {
                case '.': {
                    elems.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                case '^': {
                    if (i < len - 1) {
                        char c = path.charAt(i + 1);
                        if (c == '.' || c == '^') {
                            sb.append(c);
                            ++i;
                            continue block4;
                        }
                        if (c == '0' && sb.length() == 0 && (i == len - 2 || path.charAt(i + 2) == '.')) {
                            elems.add(null);
                            sb.setLength(0);
                            i += 2;
                            continue block4;
                        }
                        sb.append('^');
                        continue block4;
                    }
                    sb.append('^');
                    continue block4;
                }
                default: {
                    sb.append(path.charAt(i));
                }
            }
        }
        if (sb.length() > 0) {
            elems.add(sb.toString());
        } else if (path.charAt(len - 1) == '.') {
            elems.add("");
        }
        return (String[])elems.toArray(String[]::new);
    }
}

